/* This file is part of the KDE project
   Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "invitedialog.h"
#include "invitewidget.h"

#include <kiconloader.h>
#include <klocale.h>
#include <kstdguiitem.h>

#include <tqlabel.h>
#include <tqpushbutton.h>

InviteDialog::InviteDialog( TQWidget *parent, const char *name )
    : KDialogBase( parent, name, true, i18n( "Invitation" ),
      User1|Close|Help, NoDefault, true )
{
  m_inviteWidget = new InviteWidget( this, "InviteWidget" );
  m_inviteWidget->pixmapLabel->setPixmap(
      UserIcon( "connection-side-image.png" ) );
  setMainWidget( m_inviteWidget );

  setButtonGuiItem( User1, KStdGuiItem::configure() );

  connect( m_inviteWidget->btnCreateInvite, TQT_SIGNAL( clicked() ),
           TQT_SIGNAL( createInviteClicked() ) );
  connect( m_inviteWidget->btnEmailInvite, TQT_SIGNAL( clicked() ),
           TQT_SIGNAL( emailInviteClicked() ) );
  connect( m_inviteWidget->btnManageInvite, TQT_SIGNAL( clicked() ),
           TQT_SIGNAL( manageInviteClicked() ) );
}

void InviteDialog::slotUser1()
{
  emit configureClicked();
}

void InviteDialog::enableInviteButton( bool enable )
{
  m_inviteWidget->btnCreateInvite->setEnabled( enable );
}

void InviteDialog::setInviteCount( int count )
{
  m_inviteWidget->btnManageInvite->setText(
      i18n( "&Manage Invitations (%1)..." ).tqarg( count ) );
}

#include "invitedialog.moc"
