/***************************************************************************
                  kvncview.h  -  widget that shows the vnc client
                             -------------------
    begin                : Thu Dec 20 15:11:42 CET 2001
    copyright            : (C) 2001-2003 by Tim Jansen
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KVNCVIEW_H
#define KVNCVIEW_H

#include "kremoteview.h"
#include <tqcursor.h>
#include <tqmap.h>

#include "pointerlatencyometer.h"
#include "hostpreferences.h"
#include "vnctypes.h"
#include "threads.h"

class TQClipBoard;

class KVncView : public KRemoteView
{
	Q_OBJECT
  TQ_OBJECT
private:
	ControllerThread m_cthread;
	WriterThread m_wthread;
	volatile bool m_quitFlag; // if set: all threads should die ASAP
	TQMutex m_framebufferLock;
	bool m_enableFramebufferLocking;
	bool m_enableClientCursor;

	TQSize m_framebufferSize;
	bool m_scaling;
	bool m_remoteMouseTracking;
	bool m_viewOnly;

	int m_buttonMask;
	TQMap<unsigned int,bool> m_mods;

	TQString m_host;
	int m_port;

	TQClipboard *m_cb;
	bool m_dontSendCb;
	TQCursor m_cursor;
	DotCursorState m_cursorState;
	PointerLatencyOMeter m_plom;

	void mouseEvent(TQMouseEvent*);
	unsigned long toKeySym(TQKeyEvent *k);
	bool checkLocalKRfb();
	void paintMessage(const TQString &msg);
	void showDotCursorInternal();
	void unpressModifiers();

protected:
	void paintEvent(TQPaintEvent*);
	void customEvent(TQCustomEvent*);
	void mousePressEvent(TQMouseEvent*);
	void mouseDoubleClickEvent(TQMouseEvent*);
	void mouseReleaseEvent(TQMouseEvent*);
	void mouseMoveEvent(TQMouseEvent*);
	void wheelEvent(TQWheelEvent *);
	void focusOutEvent(TQFocusEvent *);
	bool x11Event(XEvent*);

public:
	KVncView(TQWidget* parent=0, const char *name=0,
		 const TQString &host = TQString(""), int port = 5900,
		 const TQString &password = TQString(),
		 Quality quality = TQUALITY_UNKNOWN,
		 DotCursorState dotCursorState = DOT_CURSOR_AUTO,
		 const TQString &encodings = TQString());
	~KVncView();
	TQSize tqsizeHint();
	void drawRegion(int x, int y, int w, int h);
	void lockFramebuffer();
	void unlockFramebuffer();
	void enableClientCursor(bool enable);
	virtual bool scaling() const;
	virtual bool supportsScaling() const;
	virtual bool supportsLocalCursor() const;
	virtual TQSize framebufferSize();
	void setRemoteMouseTracking(bool s);
	bool remoteMouseTracking();
	void configureApp(Quality q, const TQString specialEncodings = TQString());
	void showDotCursor(DotCursorState state);
	DotCursorState dotCursorState() const;
	virtual void startQuitting();
	virtual bool isQuitting();
	virtual TQString host();
	virtual int port();
	virtual bool start();

	virtual bool viewOnly();
	virtual bool startFullscreen();

	static bool editPreferences( HostPrefPtr );

public slots:
	virtual void enableScaling(bool s);
	virtual void setViewOnly(bool s);
	virtual void pressKey(XEvent *k);


private slots:
	void clipboardChanged();
	void selectionChanged();
};

#endif
