//---------------------------------------------------------------------------
//
//             kPPP: A pppd front end for the KDE project
//
//---------------------------------------------------------------------------
//
// (c) 1997-1998 Bernd Johannes Wuebben <wuebben@kde.org>
// (c) 1997-1999 Mario Weilguni <mweilguni@kde.org>
// (c) 1998-1999 Harri Porten <porten@kde.org>
//
// derived from Jay Painters "ezppp"
//
//---------------------------------------------------------------------------
//
//  $Id: providerdb.h 1246260 2011-08-10 22:19:39Z tpearson $
//
//---------------------------------------------------------------------------
//
//  This program is free software; you can redistribute it and-or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this program; if not, write to the Free
//  Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
//---------------------------------------------------------------------------

#ifndef PROVIDER_DB
#define PROVIDER_DB

#include <kwizard.h>
#include <tqwidget.h>

class TQLineEdit;
class TQListBox;
class KSimpleConfig;

class PDB_Intro : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  PDB_Intro(TQWidget *parent);
};


class PDB_Country : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  PDB_Country(TQWidget *parent);
  ~PDB_Country();
  TQListBox *lb;
  TQStringList *list;

public slots:
  void selectionChanged(int);
};


class PDB_Provider : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  PDB_Provider(TQWidget *parent);

  void setDir(const TQString &d);
  TQString getDir();

  TQListBox *lb;

public slots:
  void selectionChanged(int);

private:
  TQString dir;
};


class PDB_UserInfo : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  PDB_UserInfo(TQWidget *parent);
  TQString username();
  TQString password();
  void activate();

public slots:
  void textChanged(const TQString &);

private:
  TQLineEdit *_username;
  TQLineEdit *_password;
};


class PDB_DialPrefix : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  PDB_DialPrefix(TQWidget *parent);
  TQString prefix();
  void activate();

private:
  TQLineEdit *_prefix;
};


class PDB_Finished : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  PDB_Finished(TQWidget *parent);
};


class ProviderDB : public KWizard {
  Q_OBJECT
  TQ_OBJECT
public:
  ProviderDB(TQWidget *parent);
  ~ProviderDB();
  static TQWizard *wiz;

public slots:
  void pageSelected();
  void accept();

private:
  void loadProviderInfo();
  KSimpleConfig *cfg;

  PDB_Intro *page1;
  PDB_Country *page2;
  PDB_Provider *page3;
  PDB_UserInfo *page4;
  PDB_DialPrefix *page5;
  PDB_Finished *page9;
};


// Decodes a (some sort of)URL-encoded filename to a human-readable name.
// This is used for the provider database
void urlDecode(TQString &);

// Encodes a (some sort of)URL-encoded filename from a human-readable name.
// This is used for the provider database
void urlEncode(TQString &);


#endif
