/*
 *            kPPP: A pppd front end for the KDE project
 *
 * $Id: pppstatdlg.h 1246260 2011-08-10 22:19:39Z tpearson $
 *
 *            Copyright (C) 1997 Bernd Johannes Wuebben
 *                   wuebben@math.cornell.edu
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _PPPSTATSDLG_H_
#define _PPPSTATSDLG_H_


#include <tqdialog.h>
#include <tqevent.h>
#include <tqpixmap.h>

class TQLabel;
class TQFrame;
class TQGroupBox;
class TQLineEdit;
class TQTimer;
class TQPushButton;

const int MAX_GRAPH_WIDTH   = 600;
const int GRAPH_UPDATE_TIME = 1000;

class PPPStats;

class PPPStatsDlg : public TQWidget {

  Q_OBJECT
  TQ_OBJECT

public:

  PPPStatsDlg(TQWidget *parent, const char *name,TQWidget *main,
	      PPPStats *st);
  ~PPPStatsDlg();

protected:

  void closeEvent( TQCloseEvent *e );
  void paintEvent (TQPaintEvent *e) ;
  bool event( TQEvent *e );

public slots:

  void timeclick();
  void cancel();
  void take_stats();
  void stop_stats();
  void paintIcon(int);
  void updateGraph();

public:

  void update_data();
  void toCurrentDesktop();

private:
  void paintGraph();
  PPPStats *stats;

  TQLabel *pixmap_l;
  TQWidget *main;
  TQPushButton *cancelbutton;

  TQLabel *labela1[5];
  TQLabel *labela2[5];
  TQLabel *labelb1[5];
  TQLabel *labelb2[5];

  TQLabel *ip_address_label1;
  TQLineEdit *ip_address_label2;
  TQLabel *ip_address_label3;
  TQLineEdit *ip_address_label4;

  TQLabel *modem_pic_label;
  TQPixmap modem_pixmap;
  TQPixmap modem_left_pixmap;
  TQPixmap modem_right_pixmap;
  TQPixmap modem_both_pixmap;
  TQPixmap big_modem_both_pixmap;
  TQPixmap big_modem_left_pixmap;
  TQPixmap big_modem_right_pixmap;
  TQPixmap big_modem_none_pixmap;

  int ibytes_last;
  int obytes_last;
  bool need_to_paint;

  TQString 	ibytes_string;
  TQString 	ipackets_string;
  TQString 	compressedin_string;
  TQString 	uncompressedin_string;
  TQString 	errorin_string;
  TQString 	obytes_string;
  TQString	opackets_string;
  TQString	compressed_string;
  TQString 	packetsunc_string;
  TQString 	packetsoutunc_string;
  TQGroupBox    *box;

  // graph widget
  TQFrame *graph;
  int bin[MAX_GRAPH_WIDTH];
  int bout[MAX_GRAPH_WIDTH];
  int bin_last;
  int bout_last;
  int ringIdx;
  int max;
  TQTimer *graphTimer;
  TQColor bg, text, in, out;
};

#endif
