/*
 *              kPPP: A pppd Front End for the KDE project
 *
 * $Id: loginterm.cpp 1246260 2011-08-10 22:19:39Z tpearson $
 *
 *              Copyright (C) 1997-98 Bernd Johannes Wuebben
 *                      wuebben@math.cornell.edu
 *
 * This file was contributed by Harri Porten <porten@tu-harburg.de>
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kstdguiitem.h"

#include "loginterm.h"
#include "main.h"
#include "modem.h"

#include <stdio.h>
#include <klocale.h>

extern KPPPWidget *p_kppp;

LoginMultiLineEdit::LoginMultiLineEdit(TQWidget *parent, const char *name)
  : TQMultiLineEdit(parent, name)
{
}


LoginMultiLineEdit::~LoginMultiLineEdit() {
  Modem::modem->stop();
}


void LoginMultiLineEdit::insertChar(unsigned char c) {
  TQMultiLineEdit::insert(TQChar(c));
  p_kppp->debugwindow->addChar(c);
}


void LoginMultiLineEdit::myreturn() {
  TQMultiLineEdit::home();
}


void LoginMultiLineEdit::mynewline() {
  TQMultiLineEdit::end(FALSE);
  TQMultiLineEdit::newLine();

    p_kppp->debugwindow->addChar('\n');
}


void LoginMultiLineEdit::keyPressEvent(TQKeyEvent *k) {
  unsigned char c = (unsigned char) k->ascii();

  if ((int)c == 0) return;

  if((int)c == 13)
    Modem::modem->writeLine("");
  else
    Modem::modem->writeChar(c);
}


void LoginMultiLineEdit::readChar(unsigned char c) {

  if(((int)c != 13) && ((int)c != 10) && ((int)c != 8))
    insertChar(c);

  if((int)c == 8)
    backspace();
  if((int)c == 127)
    backspace();
  if((int)c == 10)
    mynewline();
  if((int)c == 13)
    myreturn();
}


LoginTerm::LoginTerm (TQWidget *parent, const char *name)
  : TQDialog(parent, name, FALSE)
{
  setCaption(i18n("Login Terminal Window"));
  setMinimumSize(300, 200);
  setMaximumSize(600, 400);
  resize(400, 300);

  TQVBoxLayout *tl = new TQVBoxLayout(this, 2);
  TQGridLayout *vgr = new TQGridLayout(2, 1);
  TQGridLayout *hgr = new TQGridLayout(1, 2, 30);

  tl->addLayout(vgr);
  vgr->addLayout(hgr, 1, 0);
  vgr->setRowStretch(0, 1);
  vgr->addRowSpacing(1, 40);

  text_window = new LoginMultiLineEdit(this, "term");
  text_window->setFocus();
  vgr->addWidget(text_window, 0, 0);

  cancel_b = new KPushButton(KStdGuiItem::cancel(), this, "cancel");
  cancel_b->setFixedHeight(25);
  connect(cancel_b, TQT_SIGNAL(clicked()), TQT_SLOT(cancelbutton()));

  continue_b = new KPushButton(KStdGuiItem::cont(), this, "continue");
  continue_b->setFixedHeight(25);
  connect(continue_b, TQT_SIGNAL(clicked()), TQT_SLOT(continuebutton()));

  int mwidth;
  if (cancel_b->tqsizeHint().width() > continue_b->tqsizeHint().width())
    mwidth = cancel_b->tqsizeHint().width();
  else
    mwidth = continue_b->tqsizeHint().width();

  cancel_b->setFixedWidth(mwidth + 20);
  continue_b->setFixedWidth(mwidth + 20);

  hgr->addWidget(cancel_b, 0, 0, AlignCenter);
  hgr->addWidget(continue_b, 0, 1, AlignCenter);

  cont = false;

  Modem::modem->notify(TQT_TQOBJECT(text_window), TQT_SLOT(readChar(unsigned char)));
}


void LoginTerm::cancelbutton () {
  hide();
}


void LoginTerm::continuebutton() {
  cont = true;
  hide();
}


bool LoginTerm::pressedContinue() {
  return cont;
}


#include "loginterm.moc"









