/*
 *              kPPP: A pppd Front End for the KDE project
 *
 * $Id: docking.cpp 1246260 2011-08-10 22:19:39Z tpearson $
 *
 *              Copyright (C) 1997 Bernd Johannes Wuebben
 *                      wuebben@math.cornell.edu
 *
 * This file was contributed by Harri Porten <porten@tu-harburg.de>
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <kwin.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kpopupmenu.h>

#include "docking.h"
#include "main.h"
#include "pppstats.h"

extern KPPPWidget   *p_kppp;

// static member
DockWidget *DockWidget::dock_widget = 0;

DockWidget::DockWidget(TQWidget *parent, const char *name, PPPStats *st)
  : KSystemTray(parent, name), stats(st) {

  // load pixmaps
  dock_none_pixmap = UserIcon("dock_none");
  dock_left_pixmap = UserIcon("dock_left");
  dock_right_pixmap = UserIcon("dock_right");
  dock_both_pixmap = UserIcon("dock_both");

  // popup menu for right mouse button
  popup_m = contextMenu();
  toggleID = popup_m->insertItem(i18n("Restore"),
				 this, TQT_SLOT(toggle_window_state()));
  popup_m->insertItem(i18n("Details"), p_kppp, TQT_SLOT(showStats()));
  popup_m->insertSeparator();
  popup_m->insertItem(i18n("Disconnect"), p_kppp, TQT_SLOT(disconnect()));
  // connect to stats for little modem animation
  connect(stats, TQT_SIGNAL(statsChanged(int)), TQT_SLOT(paintIcon(int)));

  DockWidget::dock_widget = this;
}


DockWidget::~DockWidget() {
  DockWidget::dock_widget = 0;
}


void DockWidget::paintEvent (TQPaintEvent *) {
  paintIcon(PPPStats::BytesNone);
}


void DockWidget::paintIcon (int status) {
  // animate modem lights

  const TQPixmap *pixmap;

  if(isVisible()) {
    switch(status)
      {
      case PPPStats::BytesBoth:
        pixmap = &dock_both_pixmap;
        break;
      case PPPStats::BytesIn:
        pixmap = &dock_left_pixmap;
        break;
      case PPPStats::BytesOut:
        pixmap = &dock_right_pixmap;
        break;
      case PPPStats::BytesNone:
      default:
        pixmap = &dock_none_pixmap;
        break;
      }

    bitBlt(this, 0, 0, pixmap);
  }
}


void DockWidget::take_stats() {
  if (isVisible()) {
    stats->initStats();
    stats->start();
  }
}


void DockWidget::stop_stats() {
  stats->stop();
}


void DockWidget::mousePressEvent(TQMouseEvent *e) {
  // open/close connect-window on right mouse button
  if ( e->button() == Qt::LeftButton ) {
    toggle_window_state();
  }

  // open popup menu on left mouse button
  if ( e->button() == Qt::RightButton ) {
    TQString text;
    if(p_kppp->con_win->isVisible())
      text = i18n("Minimize");
    else
      text = i18n("Restore");

    popup_m->changeItem(text, toggleID);
    popup_m->popup(e->globalPos());
    popup_m->exec();
  }
}


void DockWidget::toggle_window_state() {
  // restore/hide connect-window
  if(p_kppp != 0L)  {
    if (p_kppp->con_win->isVisible())
      p_kppp->con_win->hide();
    else {
      p_kppp->con_win->show();
      KWin::activateWindow(p_kppp->con_win->winId());
    }
  }
}

#include "docking.moc"
