/* -*- C++ -*-
 *            kPPP: A pppd front end for the KDE project
 *
 * $Id: accounting.h 1246260 2011-08-10 22:19:39Z tpearson $
 *
 *            Copyright (C) 1997 Bernd Johannes Wuebben
 *                   wuebben@math.cornell.edu
 * This file contributed by: Mario Weilguni, <mweilguni@sime.com>
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef __ACCOUNTING__H__
#define __ACCOUNTING__H__

#include <tqobject.h>
#include <kprocess.h>
#include "ruleset.h"

class PPPStats;

/////////////////////////////////////////////////////////////////////////////
//
// Accounting base class
//
/////////////////////////////////////////////////////////////////////////////
class AccountingBase : public TQObject {
  Q_OBJECT
  TQ_OBJECT
public:
  AccountingBase(TQObject *parent);
  virtual ~AccountingBase();

  virtual double total() const;
  virtual double session() const;

  virtual bool running() const { return false; };
  virtual bool loadRuleSet(const TQString & name) = 0;

public slots:
  virtual void slotStart() {};
  virtual void slotStop() {};

signals:
  void changed(TQString total, TQString session);

protected:
  void logMessage(TQString, bool = FALSE);
  bool saveCosts();
  bool loadCosts();

  TQString LogFileName;
  double _total, _session;
  TQString _name;

  // static members
public:
  static void resetCosts(const TQString & accountname);
  static void resetVolume(const TQString & accountname);
  static TQString getCosts(const TQString & accountname);
  static TQString getAccountingFile(const TQString &accountname);
};


/////////////////////////////////////////////////////////////////////////////
//
// Accounting based on ruleset files
//
/////////////////////////////////////////////////////////////////////////////
class Accounting : public AccountingBase {
  Q_OBJECT
  TQ_OBJECT
public:
  Accounting(TQObject *parent, PPPStats *st);

  virtual double total() const;
  virtual double session() const;

  virtual bool loadRuleSet(const TQString & name);
  virtual bool running() const;

private:
  virtual void timerEvent(TQTimerEvent *t);

public slots:
  virtual void slotStart();
  virtual void slotStop();

signals:
  void changed(TQString total, TQString session);

private:
  int acct_timer_id;
  int update_timer_id;
  time_t start_time;
  double _lastcosts;
  double _lastlen;
  RuleSet rules;
  PPPStats *stats;
};


/////////////////////////////////////////////////////////////////////////////
//
// Accounting based on executable files
//
/////////////////////////////////////////////////////////////////////////////
class ExecutableAccounting : public AccountingBase {
  Q_OBJECT
  TQ_OBJECT
public:
  ExecutableAccounting(PPPStats *st, TQObject *parent = 0);

  virtual bool loadRuleSet(const TQString & );
  virtual bool running() const;

public slots:
  virtual void slotStart();
  virtual void slotStop();

private slots:
  void gotData(KProcess *proc, char *buffer, int buflen);

signals:
  void changed(TQString total, TQString session);

private:
  KProcess *proc;
  TQString currency;
  TQString provider;
  PPPStats *stats;
};

#endif
