/*
    Kopete Yahoo Protocol
    Handles incoming webcam connections

    Copyright (c) 2005 André Duffeck <duffeck@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef WEBCAMTASK_H
#define WEBCAMTASK_H

#include "task.h"
#include <tqmap.h>
#include <tqpixmap.h>
#include <tqstringlist.h>

class TQString;
class YMSGTransfer;
class TQBuffer;
namespace KNetwork {
	class KStreamSocket;
}
using namespace KNetwork;

enum ConnectiontqStatus{ InitialtqStatus, ConnectedStage1, ConnectedStage2, Receiving, Sending, SendingEmpty };
enum PacketType { Image, ConnectionClosed, UserRequest, NewWatcher, WatcherLeft };
enum Direction { Incoming, Outgoing };

struct YahooWebcamInformation
{
	TQString		sender;
	TQString		server;
	TQString		key;
	ConnectiontqStatus status;
	PacketType	type;
	Direction	direction;
	uchar		reason;
	TQ_INT32		dataLength;
	TQ_INT32		timestamp;
	bool		headerRead;
	TQBuffer 	*buffer;
};

typedef TQMap< KStreamSocket *, YahooWebcamInformation > SocketInfoMap;

/**
@author André Duffeck
*/
class WebcamTask : public Task
{
	Q_OBJECT
  TQ_OBJECT
public:
	WebcamTask(Task *parent);
	~WebcamTask();

	bool take(Transfer *transfer);

	bool transmitting() { return transmittingData; }

	void requestWebcam( const TQString &who );
	void closeWebcam( const TQString &who );

	void registerWebcam();
	void sendWebcamImage( const TQByteArray &image );
	void addPendingInvitation( const TQString &userId );
	void grantAccess( const TQString &userId );
	void closeOutgoingWebcam();
signals:
	void webcamNotAvailable( const TQString & );
	void webcamClosed( const TQString &, int );
	void webcamPaused( const TQString& );
	void webcamImageReceived( const TQString &, const TQPixmap &);
	void readyForTransmission();
	void stopTransmission();
	void viewerJoined( const TQString & );
	void viewerLeft( const TQString & );
	void viewerRequest( const TQString & );
private slots:
	void slotConnectionStage1Established();
	void slotConnectionStage2Established();
	void slotConnectionFailed(int);
	void slotRead();
	void sendEmptyWebcamImage();
	void transmitWebcamImage();
protected:
	virtual bool forMe( const Transfer* transfer ) const;
private:
	void parseWebcamInformation( YMSGTransfer *transfer );
	void parseData( TQByteArray &data, KStreamSocket *socket );

	void connectStage2( KStreamSocket *socket );
	void processData( KStreamSocket *socket );
	void cleanUpConnection( KStreamSocket *socket );

	TQString keyPending;	// the buddy we have requested the webcam from
	SocketInfoMap socketMap;
	bool transmittingData;
	TQStringList pendingInvitations;
	TQStringList accessGranted;
	int timestamp;
	TQByteArray pictureBuffer;
	bool transmissionPending;
};

#endif
