/*
    Kopete Yahoo Protocol
    sendpicturetask.h - Send our picture or information about it

    Copyright (c) 2005 André Duffeck <duffeck@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef SENDPICTURETASK_H
#define SENDPICTURETASK_H

#include "task.h"

class TQString;
class TQFile;
namespace KIO	{
	class Job;
	class TransferJob;
}
namespace KNetwork	{
	class KBufferedSocket;
}

/**
@author André Duffeck
*/
class SendPictureTask : public Task
{
Q_OBJECT
  TQ_OBJECT
public:
	enum Type { UploadPicture, SendChecksum, SendInformation, SendtqStatus };

	SendPictureTask(Task *parent);
	virtual ~SendPictureTask();

	virtual void onGo();

	void setType( Type type );
	void setTarget( const TQString &to );
	void setFilename( const TQString & );
	void setFilesize( int );
	void setPath( const TQString & );
	void setChecksum( int );
	void settqStatus( int );
	void setUrl( const TQString & );
private:
	void initiateUpload();
	void sendChecksum();
	void sendInformation();
	void sendtqStatus();
private slots:
	void connectSucceeded();
	void connectFailed( int );
	void readResult();
private:
	Type m_type;
	TQString m_target;
	TQString m_fileName;
	int m_fileSize;
	TQString m_path;
	int m_checksum;
	int m_status;
	TQString m_url;
	int m_transmitted;
	TQFile *m_file;
	KNetwork::KBufferedSocket *m_socket;
};

#endif
