/***************************************************************************
     wpprotocol.h  -  Base class for the Kopete WP protocol
                             -------------------
    begin                : Fri Apr 26 2002
    copyright            : (C) 2002 by Gav Wood
    email                : gav@kde.org

    Based on code from   : (C) 2002 by Duncan Mac-Vicar Prett
    email                : duncan@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WPPROTOCOL_H
#define WPPROTOCOL_H

// QT Includes
#include <tqpixmap.h>
#include <tqptrlist.h>
#include <tqdatetime.h>

// Kopete Includes
#include "kopetemetacontact.h"
#include "kopeteprotocol.h"
#include "kopeteonlinestatus.h"

// Local Includes
#include "libwinpopup.h"
#include "wpaddcontact.h"

namespace Kopete { class Account; }
class KPopupMenu;
class KActionMenu;
class KAction;
class WPContact;
class WPAccount;

/**
 * The actual Protocol class used by Kopete.
 */
class WPProtocol : public Kopete::Protocol
{
	Q_OBJECT
  TQ_OBJECT

// Kopete::Protocol overloading
public:
	WPProtocol( TQObject *parent, const char *name, const TQStringList &args );
	~WPProtocol();

	virtual AddContactPage *createAddContactWidget(TQWidget *parent, Kopete::Account *theAccount);
	virtual KopeteEditAccountWidget *createEditAccountWidget(Kopete::Account *account, TQWidget *parent);
	virtual Kopete::Account *createNewAccount(const TQString &accountId);

	const TQStringList getGroups() {return popupClient->getGroups(); }
	const TQStringList getHosts(const TQString &Group) { return popupClient->getHosts(Group); }
	bool checkHost(const TQString &Name) { return popupClient->checkHost(Name); }

// Kopete::Plugin overloading
public:
	virtual Kopete::Contact *deserializeContact(Kopete::MetaContact *metaContact, const TQMap<TQString, TQString> &serializedData, const TQMap<TQString, TQString> &addressBookData);

// Stuff used internally & by colleague classes
public:
	static WPProtocol *protocol() { return sProtocol; }

	const Kopete::OnlineStatus WPOnline;
	const Kopete::OnlineStatus WPAway;
	const Kopete::OnlineStatus WPOffline;
	void sendMessage(const TQString &Body, const TQString &Destination);
	void settingsChanged(void);			// Callback when settings changed

public slots:
	void installSamba();				// Modify smb.conf to use winpopup-send.sh script
	void slotReceivedMessage(const TQString &Body, const TQDateTime &Time, const TQString &From);

private:
	TQString smbClientBin;
	int groupCheckFreq;
	void readConfig();
	WinPopupLib *popupClient;
	static WPProtocol *sProtocol;			// Singleton
};

#endif

// vim: set noet ts=4 sts=4 sw=4:
// kate: tab-width 4; indent-width 4; replace-trailing-space-save on;
