//Licensed under the GNU General Public License

#include "ssigrouptest.h"

LoginTest::LoginTest(int argc, char ** argv) : TQApplication( argc, argv )
{
	// set up client stream
	myConnector = new KNetworkConnector( 0 );
	myConnector->setOptHostPort( "login.oscar.aol.com", 5190 );
	myTestObject = new ClientStream( myConnector, myConnector);
	
	// notify when the transport layer is connected
	//connect( myTestObject, TQT_SIGNAL( connected() ), TQT_SLOT( slotConnected() ) );
	myClient = new Client();
	
	myConnection = new Connection( myConnector, myTestObject, "AUTHORIZER" );
	myConnection->setClient( myClient );
	// do test once the event loop is running
	TQTimer::singleShot( 0, this, TQT_SLOT( slotDoTest() ) );
	connected = false;
}

LoginTest::~LoginTest()
{
	delete myTestObject;
	delete myConnector;
	delete myClient;
}

void LoginTest::slotDoTest()
{
	TQString server = TQString::tqfromLatin1("login.oscar.aol.com");
	// connect to server
	qDebug( "connecting to server ");

	myClient->setIsIcq( true );
	myClient->start( server, 5190, "userid", "password" );
	myClient->connectToServer( myConnection, server, true );
	TQTimer::singleShot( 10000, this, TQT_SLOT(runAddGroupTest() ) );
	connected = true;
}

void LoginTest::slotConnected()
{
	qDebug( "connection is up");
	connected = true;
}

int main(int argc, char ** argv)
{
	LoginTest a( argc, argv );
	a.exec();
	if ( !a.isConnected() )
		return 0;
}

void LoginTest::runAddGroupTest()
{
	qDebug( "running ssi group add test" );
	TQString group = TQString::tqfromLatin1( "dummygroup" );
	myClient->addGroup( group );
	TQTimer::singleShot( 5000, this, TQT_SLOT( runDelGroupTest() ) );
}

void LoginTest::runDelGroupTest()
{
	qDebug( "running ssi group del test" );
	TQString group = TQString::tqfromLatin1( "dummygroup" );
	myClient->removeGroup( group );
}


#include "ssigrouptest.moc"
