/*
 * parser.h - parse an XMPP "document"
 * Copyright (C) 2003  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PARSER_H
#define PARSER_H

#include<tqdom.h>
#include<tqxml.h>

namespace XMPP
{
	class Parser
	{
	public:
		Parser();
		~Parser();

		class Event
		{
		public:
			enum Type { DocumentOpen, DocumentClose, Element, Error };
			Event();
			Event(const Event &);
			Event & operator=(const Event &);
			~Event();

			bool isNull() const;
			int type() const;

			// for document open
			TQString nsprefix(const TQString &s=TQString()) const;

			// for document open / close
			TQString namespaceURI() const;
			TQString localName() const;
			TQString qName() const;
			TQXmlAttributes atts() const;

			// for element
			TQDomElement element() const;

			// for any
			TQString actualString() const;

			// setup
			void setDocumentOpen(const TQString &namespaceURI, const TQString &localName, const TQString &qName, const TQXmlAttributes &atts, const TQStringList &nsnames, const TQStringList &nsvalues);
			void setDocumentClose(const TQString &namespaceURI, const TQString &localName, const TQString &qName);
			void setElement(const TQDomElement &elem);
			void setError();
			void setActualString(const TQString &);

		private:
			class Private;
			Private *d;
		};

		void reset();
		void appendData(const TQByteArray &a);
		Event readNext();
		TQByteArray unprocessed() const;
		TQString encoding() const;

	private:
		class Private;
		Private *d;
	};
}

#endif
