/*
 * srvresolver.h - class to simplify SRV lookups
 * Copyright (C) 2003  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef CS_SRVRESOLVER_H
#define CS_SRVRESOLVER_H

#include<tqvaluelist.h>
#include<tqdns.h>

// CS_NAMESPACE_BEGIN

class SrvResolver : public TQObject
{
	Q_OBJECT
  TQ_OBJECT
public:
	SrvResolver(TQObject *parent=0);
	~SrvResolver();

	void resolve(const TQString &server, const TQString &type, const TQString &proto);
	void resolveSrvOnly(const TQString &server, const TQString &type, const TQString &proto);
	void next();
	void stop();
	bool isBusy() const;

	TQValueList<TQDns::Server> servers() const;

	bool failed() const;
	TQHostAddress resultAddress() const;
	TQ_UINT16 resultPort() const;

signals:
	void resultsReady();

private slots:
	void qdns_done();
	void ndns_done();
	void t_timeout();

private:
	class Private;
	Private *d;

	void tryNext();
};

// CS_NAMESPACE_END

#endif
