/*
 * libjingle
 * Copyright 2004--2005, Google Inc.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string>
#include "talk/base/basicdefs.h"
#include "talk/xmllite/xmlconstants.h"
#include "talk/xmllite/xmlelement.h"
#include "talk/xmllite/tqname.h"
#include "talk/xmpp/jid.h"
#include "talk/xmpp/constants.h"
namespace buzz {

const Jid JID_EMPTY(STR_EMPTY);

const std::string & Constants::ns_client() {
  static const std::string ns_client_("jabber:client");
  return ns_client_;
}

const std::string & Constants::ns_server() {
  static const std::string ns_server_("jabber:server");
  return ns_server_;
}

const std::string & Constants::ns_stream() {
  static const std::string ns_stream_("http://etherx.jabber.org/streams");
  return ns_stream_;
}

const std::string & Constants::ns_xstream() {
  static const std::string ns_xstream_("urn:ietf:params:xml:ns:xmpp-streams");
  return ns_xstream_;
}

const std::string & Constants::ns_tls() {
  static const std::string ns_tls_("urn:ietf:params:xml:ns:xmpp-tls");
  return ns_tls_;
}

const std::string & Constants::ns_sasl() {
  static const std::string ns_sasl_("urn:ietf:params:xml:ns:xmpp-sasl");
  return ns_sasl_;
}

const std::string & Constants::ns_bind() {
  static const std::string ns_bind_("urn:ietf:params:xml:ns:xmpp-bind");
  return ns_bind_;
}

const std::string & Constants::ns_dialback() {
  static const std::string ns_dialback_("jabber:server:dialback");
  return ns_dialback_;
}

const std::string & Constants::ns_session() {
  static const std::string ns_session_("urn:ietf:params:xml:ns:xmpp-session");
  return ns_session_;
}

const std::string & Constants::ns_stanza() {
  static const std::string ns_stanza_("urn:ietf:params:xml:ns:xmpp-stanzas");
  return ns_stanza_;
}

const std::string & Constants::ns_privacy() {
  static const std::string ns_privacy_("jabber:iq:privacy");
  return ns_privacy_;
}

const std::string & Constants::ns_roster() {
  static const std::string ns_roster_("jabber:iq:roster");
  return ns_roster_;
}

const std::string & Constants::ns_vcard() {
  static const std::string ns_vcard_("vcard-temp");
  return ns_vcard_;
}

const std::string & Constants::str_client() {
  static const std::string str_client_("client");
  return str_client_;
}

const std::string & Constants::str_server() {
  static const std::string str_server_("server");
  return str_server_;
}

const std::string & Constants::str_stream() {
  static const std::string str_stream_("stream");
  return str_stream_;
}

const std::string STR_GET("get");
const std::string STR_SET("set");
const std::string STR_RESULT("result");
const std::string STR_ERROR("error");

const std::string STR_FROM("from");
const std::string STR_TO("to");
const std::string STR_BOTH("both");
const std::string STR_REMOVE("remove");

const std::string STR_UNAVAILABLE("unavailable");
const std::string STR_INVISIBLE("invisible");

const std::string STR_GOOGLE_COM("google.com");
const std::string STR_GMAIL_COM("gmail.com");
const std::string STR_GOOGLEMAIL_COM("googlemail.com");
const std::string STR_DEFAULT_DOMAIN("default.talk.google.com");
const std::string STR_X("x");

const TQName TQN_STREAM_STREAM(true, NS_STREAM, STR_STREAM);
const TQName TQN_STREAM_FEATURES(true, NS_STREAM, "features");
const TQName TQN_STREAM_ERROR(true, NS_STREAM, "error");

const TQName TQN_XSTREAM_BAD_FORMAT(true, NS_XSTREAM, "bad-format");
const TQName TQN_XSTREAM_BAD_NAMESPACE_PREFIX(true, NS_XSTREAM, "bad-namespace-prefix");
const TQName TQN_XSTREAM_CONFLICT(true, NS_XSTREAM, "conflict");
const TQName TQN_XSTREAM_CONNECTION_TIMEOUT(true, NS_XSTREAM, "connection-timeout");
const TQName TQN_XSTREAM_HOST_GONE(true, NS_XSTREAM, "host-gone");
const TQName TQN_XSTREAM_HOST_UNKNOWN(true, NS_XSTREAM, "host-unknown");
const TQName TQN_XSTREAM_IMPROPER_ADDRESSIING(true, NS_XSTREAM, "improper-addressing");
const TQName TQN_XSTREAM_INTERNAL_SERVER_ERROR(true, NS_XSTREAM, "internal-server-error");
const TQName TQN_XSTREAM_INVALID_FROM(true, NS_XSTREAM, "invalid-from");
const TQName TQN_XSTREAM_INVALID_ID(true, NS_XSTREAM, "invalid-id");
const TQName TQN_XSTREAM_INVALID_NAMESPACE(true, NS_XSTREAM, "invalid-namespace");
const TQName TQN_XSTREAM_INVALID_XML(true, NS_XSTREAM, "invalid-xml");
const TQName TQN_XSTREAM_NOT_AUTHORIZED(true, NS_XSTREAM, "not-authorized");
const TQName TQN_XSTREAM_POLICY_VIOLATION(true, NS_XSTREAM, "policy-violation");
const TQName TQN_XSTREAM_REMOTE_CONNECTION_FAILED(true, NS_XSTREAM, "remote-connection-failed");
const TQName TQN_XSTREAM_RESOURCE_CONSTRAINT(true, NS_XSTREAM, "resource-constraint");
const TQName TQN_XSTREAM_RESTRICTED_XML(true, NS_XSTREAM, "restricted-xml");
const TQName TQN_XSTREAM_SEE_OTHER_HOST(true, NS_XSTREAM, "see-other-host");
const TQName TQN_XSTREAM_SYSTEM_SHUTDOWN(true, NS_XSTREAM, "system-shutdown");
const TQName TQN_XSTREAM_UNDEFINED_CONDITION(true, NS_XSTREAM, "undefined-condition");
const TQName TQN_XSTREAM_UNSUPPORTED_ENCODING(true, NS_XSTREAM, "unsupported-encoding");
const TQName TQN_XSTREAM_UNSUPPORTED_STANZA_TYPE(true, NS_XSTREAM, "unsupported-stanza-type");
const TQName TQN_XSTREAM_UNSUPPORTED_VERSION(true, NS_XSTREAM, "unsupported-version");
const TQName TQN_XSTREAM_XML_NOT_WELL_FORMED(true, NS_XSTREAM, "xml-not-well-formed");
const TQName TQN_XSTREAM_TEXT(true, NS_XSTREAM, "text");

const TQName TQN_TLS_STARTTLS(true, NS_TLS, "starttls");
const TQName TQN_TLS_RETQUIRED(true, NS_TLS, "required");
const TQName TQN_TLS_PROCEED(true, NS_TLS, "proceed");
const TQName TQN_TLS_FAILURE(true, NS_TLS, "failure");

const TQName TQN_SASL_MECHANISMS(true, NS_SASL, "mechanisms");
const TQName TQN_SASL_MECHANISM(true, NS_SASL, "mechanism");
const TQName TQN_SASL_AUTH(true, NS_SASL, "auth");
const TQName TQN_SASL_CHALLENGE(true, NS_SASL, "challenge");
const TQName TQN_SASL_RESPONSE(true, NS_SASL, "response");
const TQName TQN_SASL_ABORT(true, NS_SASL, "abort");
const TQName TQN_SASL_SUCCESS(true, NS_SASL, "success");
const TQName TQN_SASL_FAILURE(true, NS_SASL, "failure");
const TQName TQN_SASL_ABORTED(true, NS_SASL, "aborted");
const TQName TQN_SASL_INCORRECT_ENCODING(true, NS_SASL, "incorrect-encoding");
const TQName TQN_SASL_INVALID_AUTHZID(true, NS_SASL, "invalid-authzid");
const TQName TQN_SASL_INVALID_MECHANISM(true, NS_SASL, "invalid-mechanism");
const TQName TQN_SASL_MECHANISM_TOO_WEAK(true, NS_SASL, "mechanism-too-weak");
const TQName TQN_SASL_NOT_AUTHORIZED(true, NS_SASL, "not-authorized");
const TQName TQN_SASL_TEMPORARY_AUTH_FAILURE(true, NS_SASL, "temporary-auth-failure");

const TQName TQN_DIALBACK_RESULT(true, NS_DIALBACK, "result");
const TQName TQN_DIALBACK_VERIFY(true, NS_DIALBACK, "verify");

const TQName TQN_STANZA_BAD_REQUEST(true, NS_STANZA, "bad-request");
const TQName TQN_STANZA_CONFLICT(true, NS_STANZA, "conflict");
const TQName TQN_STANZA_FEATURE_NOT_IMPLEMENTED(true, NS_STANZA, "feature-not-implemented");
const TQName TQN_STANZA_FORBIDDEN(true, NS_STANZA, "forbidden");
const TQName TQN_STANZA_GONE(true, NS_STANZA, "gone");
const TQName TQN_STANZA_INTERNAL_SERVER_ERROR(true, NS_STANZA, "internal-server-error");
const TQName TQN_STANZA_ITEM_NOT_FOUND(true, NS_STANZA, "item-not-found");
const TQName TQN_STANZA_JID_MALFORMED(true, NS_STANZA, "jid-malformed");
const TQName TQN_STANZA_NOT_ACCEPTABLE(true, NS_STANZA, "not-acceptable");
const TQName TQN_STANZA_NOT_ALLOWED(true, NS_STANZA, "not-allowed");
const TQName TQN_STANZA_PAYMENT_RETQUIRED(true, NS_STANZA, "payment-required");
const TQName TQN_STANZA_RECIPIENT_UNAVAILABLE(true, NS_STANZA, "recipient-unavailable");
const TQName TQN_STANZA_REDIRECT(true, NS_STANZA, "redirect");
const TQName TQN_STANZA_REGISTRATION_RETQUIRED(true, NS_STANZA, "registration-required");
const TQName TQN_STANZA_REMOTE_SERVER_NOT_FOUND(true, NS_STANZA, "remote-server-not-found");
const TQName TQN_STANZA_REMOTE_SERVER_TIMEOUT(true, NS_STANZA, "remote-server-timeout");
const TQName TQN_STANZA_RESOURCE_CONSTRAINT(true, NS_STANZA, "resource-constraint");
const TQName TQN_STANZA_SERVICE_UNAVAILABLE(true, NS_STANZA, "service-unavailable");
const TQName TQN_STANZA_SUBSCRIPTION_RETQUIRED(true, NS_STANZA, "subscription-required");
const TQName TQN_STANZA_UNDEFINED_CONDITION(true, NS_STANZA, "undefined-condition");
const TQName TQN_STANZA_UNEXPECTED_REQUEST(true, NS_STANZA, "unexpected-request");
const TQName TQN_STANZA_TEXT(true, NS_STANZA, "text");

const TQName TQN_BIND_BIND(true, NS_BIND, "bind");
const TQName TQN_BIND_RESOURCE(true, NS_BIND, "resource");
const TQName TQN_BIND_JID(true, NS_BIND, "jid");

const TQName TQN_MESSAGE(true, NS_CLIENT, "message");
const TQName TQN_BODY(true, NS_CLIENT, "body");
const TQName TQN_SUBJECT(true, NS_CLIENT, "subject");
const TQName TQN_THREAD(true, NS_CLIENT, "thread");
const TQName TQN_PRESENCE(true, NS_CLIENT, "presence");
const TQName TQN_SHOW(true, NS_CLIENT, "show");
const TQName TQN_STATUS(true, NS_CLIENT, "status");
const TQName TQN_LANG(true, NS_CLIENT, "lang");
const TQName TQN_PRIORITY(true, NS_CLIENT, "priority");
const TQName TQN_IQ(true, NS_CLIENT, "iq");
const TQName TQN_ERROR(true, NS_CLIENT, "error");

const TQName TQN_SERVER_MESSAGE(true, NS_SERVER, "message");
const TQName TQN_SERVER_BODY(true, NS_SERVER, "body");
const TQName TQN_SERVER_SUBJECT(true, NS_SERVER, "subject");
const TQName TQN_SERVER_THREAD(true, NS_SERVER, "thread");
const TQName TQN_SERVER_PRESENCE(true, NS_SERVER, "presence");
const TQName TQN_SERVER_SHOW(true, NS_SERVER, "show");
const TQName TQN_SERVER_STATUS(true, NS_SERVER, "status");
const TQName TQN_SERVER_LANG(true, NS_SERVER, "lang");
const TQName TQN_SERVER_PRIORITY(true, NS_SERVER, "priority");
const TQName TQN_SERVER_IQ(true, NS_SERVER, "iq");
const TQName TQN_SERVER_ERROR(true, NS_SERVER, "error");

const TQName TQN_SESSION_SESSION(true, NS_SESSION, "session");

const TQName TQN_PRIVACY_TQUERY(true, NS_PRIVACY, "query");
const TQName TQN_PRIVACY_ACTIVE(true, NS_PRIVACY, "active");
const TQName TQN_PRIVACY_DEFAULT(true, NS_PRIVACY, "default");
const TQName TQN_PRIVACY_LIST(true, NS_PRIVACY, "list");
const TQName TQN_PRIVACY_ITEM(true, NS_PRIVACY, "item");
const TQName TQN_PRIVACY_IQ(true, NS_PRIVACY, "iq");
const TQName TQN_PRIVACY_MESSAGE(true, NS_PRIVACY, "message");
const TQName TQN_PRIVACY_PRESENCE_IN(true, NS_PRIVACY, "presence-in");
const TQName TQN_PRIVACY_PRESENCE_OUT(true, NS_PRIVACY, "presence-out");

const TQName TQN_ROSTER_TQUERY(true, NS_ROSTER, "query");
const TQName TQN_ROSTER_ITEM(true, NS_ROSTER, "item");
const TQName TQN_ROSTER_GROUP(true, NS_ROSTER, "group");

const TQName TQN_VCARD_TQUERY(true, NS_VCARD, "vCard");
const TQName TQN_VCARD_FN(true, NS_VCARD, "FN");

const TQName TQN_XML_LANG(true, NS_XML, "lang");

const std::string STR_TYPE("type");
const std::string STR_ID("id");
const std::string STR_NAME("name");
const std::string STR_JID("jid");
const std::string STR_SUBSCRIPTION("subscription");
const std::string STR_ASK("ask");

const TQName TQN_ENCODING(true, STR_EMPTY, STR_ENCODING);
const TQName TQN_VERSION(true, STR_EMPTY, STR_VERSION);
const TQName TQN_TO(true, STR_EMPTY, "to");
const TQName TQN_FROM(true, STR_EMPTY, "from");
const TQName TQN_TYPE(true, STR_EMPTY, "type");
const TQName TQN_ID(true, STR_EMPTY, "id");
const TQName TQN_CODE(true, STR_EMPTY, "code");
const TQName TQN_NAME(true, STR_EMPTY, "name");
const TQName TQN_VALUE(true, STR_EMPTY, "value");
const TQName TQN_ACTION(true, STR_EMPTY, "action");
const TQName TQN_ORDER(true, STR_EMPTY, "order");
const TQName TQN_MECHANISM(true, STR_EMPTY, "mechanism");
const TQName TQN_ASK(true, STR_EMPTY, "ask");
const TQName TQN_JID(true, STR_EMPTY, "jid");
const TQName TQN_SUBSCRIPTION(true, STR_EMPTY, "subscription");
const TQName TQN_SOURCE(true, STR_EMPTY, "source");

const TQName TQN_XMLNS_CLIENT(true, NS_XMLNS, STR_CLIENT);
const TQName TQN_XMLNS_SERVER(true, NS_XMLNS, STR_SERVER);
const TQName TQN_XMLNS_STREAM(true, NS_XMLNS, STR_STREAM);

// Presence
const std::string STR_SHOW_AWAY("away");
const std::string STR_SHOW_CHAT("chat");
const std::string STR_SHOW_DND("dnd");
const std::string STR_SHOW_XA("xa");

// Subscription
const std::string STR_SUBSCRIBE("subscribe");
const std::string STR_SUBSCRIBED("subscribed");
const std::string STR_UNSUBSCRIBE("unsubscribe");
const std::string STR_UNSUBSCRIBED("unsubscribed");


// JEP 0030
const TQName TQN_NODE(true, STR_EMPTY, "node");
const TQName TQN_CATEGORY(true, STR_EMPTY, "category");
const TQName TQN_VAR(true, STR_EMPTY, "var");
const std::string NS_DISCO_INFO("http://jabber.org/protocol/disco#info");
const std::string NS_DISCO_ITEMS("http://jabber.org/protocol/disco#items");
const TQName TQN_DISCO_INFO_TQUERY(true, NS_DISCO_INFO, "query");
const TQName TQN_DISCO_IDENTITY(true, NS_DISCO_INFO, "identity");
const TQName TQN_DISCO_FEATURE(true, NS_DISCO_INFO, "feature");

const TQName TQN_DISCO_ITEMS_TQUERY(true, NS_DISCO_ITEMS, "query");
const TQName TQN_DISCO_ITEM(true, NS_DISCO_ITEMS, "item");


// JEP 0115
const std::string NS_CAPS("http://jabber.org/protocol/caps");
const TQName TQN_CAPS_C(true, NS_CAPS, "c");
const TQName TQN_VER(true, STR_EMPTY, "ver");
const TQName TQN_EXT(true, STR_EMPTY, "ext");

// JEP 0091 Delayed Delivery
const std::string kNSDelay("jabber:x:delay");
const TQName kQnDelayX(true, kNSDelay, "x");
const TQName kQnStamp(true, STR_EMPTY, "stamp");


}
