 /*
  * jabberformtranslator.cpp
  *
  * Copyright (c) 2002-2003 by Till Gerken <till@tantalo.net>
  *
  * Kopete    (c) by the Kopete developers  <kopete-devel@kde.org>
  *
  * *************************************************************************
  * *                                                                       *
  * * This program is free software; you can redistribute it and/or modify  *
  * * it under the terms of the GNU General Public License as published by  *
  * * the Free Software Foundation; either version 2 of the License, or     *
  * * (at your option) any later version.                                   *
  * *                                                                       *
  * *************************************************************************
  */

#include <tqlabel.h>

#include <kdebug.h>

#include "jabberformlineedit.h"
#include "jabberformtranslator.h"

JabberFormTranslator::JabberFormTranslator (const XMPP::Form & form, TQWidget * parent, const char *name):TQWidget (parent, name)
{
	/* Copy basic form values. */
	privForm.setJid (form.jid ());
	privForm.setInstructions (form.instructions ());
	privForm.setKey (form.key ());

	emptyForm = privForm;

	/* Add instructions to tqlayout. */
	TQVBoxLayout *innerLayout = new TQVBoxLayout (this, 0, 4);

	TQLabel *label = new TQLabel (form.instructions (), this, "InstructionLabel");
	label->tqsetAlignment (int (TQLabel::WordBreak | TQLabel::AlignVCenter));
	label->tqsetSizePolicy(TQSizePolicy::Minimum,TQSizePolicy::Fixed, true);
	label->show ();

	innerLayout->addWidget (label, 0);

	TQGridLayout *formLayout = new TQGridLayout (innerLayout, form.count (), 2);

	int row = 1;
	XMPP::Form::const_iterator formEnd = form.end ();
	for (XMPP::Form::const_iterator it = form.begin (); it != formEnd; ++it, ++row)
	{
		kdDebug (14130) << "[JabberFormTranslator] Adding field realName()==" <<
			(*it).realName () << ", fieldName()==" << (*it).fieldName () << " to the dialog" << endl;

		label = new TQLabel ((*it).fieldName (), this, (*it).fieldName ().latin1 ());
		formLayout->addWidget (label, row, 0);
		label->show ();

		TQLineEdit *edit;
		if ((*it).type() == XMPP::FormField::password)
		{
			edit = new JabberFormPasswordEdit((*it).type (), (*it).realName (), (*it).value (), this);
		}
		else
		{
			edit = new JabberFormLineEdit ((*it).type (), (*it).realName (),
		                                                   (*it).value (), this);
		}
		formLayout->addWidget (edit, row, 1);
		edit->show ();

		connect (this, TQT_SIGNAL (gatherData (XMPP::Form &)), edit, TQT_SLOT (slotGatherData (XMPP::Form &)));
	}

	innerLayout->addStretch ();
}

XMPP::Form & JabberFormTranslator::resultData ()
{
	// clear form data
	privForm = emptyForm;

	// let all line edit fields write into our form
	emit gatherData (privForm);

	return privForm;
}

JabberFormTranslator::~JabberFormTranslator ()
{
}

#include "jabberformtranslator.moc"
