/*
    kirctransfer.h - DCC Handler

    Copyright (c) 2003-2004 by Michel Hermier <michel.hermier@wanadoo.fr>

    Kopete    (c) 2003-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KIRCTRANSFERSERVER_H
#define KIRCTRANSFERSERVER_H

#include "kirctransfer.h"

#include <tqobject.h>

class KExtendedSocket;

class TQFile;
class TQTextCodec;

namespace KIRC
{

class TransferServer
	: public TQObject
{
	Q_OBJECT
  TQ_OBJECT

public:
//	TransferServer(TQObject *parent = 0, const char *name = 0);
	TransferServer(TQ_UINT16 port, int backlog = 1, TQObject *parent = 0, const char *name = 0);
	TransferServer(KIRC::Engine *engine, TQString nick,// TQString nick_peer_adress,
			Transfer::Type type,
			TQString fileName, TQ_UINT32 fileSize,
			TQObject *parent = 0, const char *name = 0);

	~TransferServer();

	int port()
	{ return m_port; }

protected:
	bool initServer();
	bool initServer( TQ_UINT16 port, int backlog = 1 );

signals:
	void incomingNewTransfer(Transfer *transfer);

protected slots:
	void readyAccept();
	void connectionFailed(int error);

private:
	KExtendedSocket *	m_socket;
	TQ_UINT16		m_port;
	int			m_backlog;

	// The following will be deprecated ...
	KIRC::Engine *		m_engine;
	TQString			m_nick;
	Transfer::Type	m_type;
	TQString			m_fileName;
	TQ_UINT32		m_fileSize;
	// by
	// TQPtrList<Transfer> m_pendingTransfers;
	// TQPtrList<Transfer> m_activeTransfers;

};

}

#endif
