/*
	detectornetworkstatus.cpp

	Copyright (c) 2006      by Heiko Schaefer        <heiko@rangun.de>

	Kopete    (c) 2002-2006 by the Kopete developers <kopete-devel@kde.org>

	*************************************************************************
	*                                                                       *
	* This program is free software; you can redistribute it and/or modify  *
	* it under the terms of the GNU General Public License as published by  *
	* the Free Software Foundation; version 2 of the License.               *
	*                                                                       *
	*************************************************************************
*/

#include <kdebug.h>

#include "kopeteuiglobal.h"
#include "connectionmanager.h"

#include "iconnector.h"
#include "detectornetworkstatus.h"

DetectorNetworktqStatus::DetectorNetworktqStatus(IConnector* connector) 
	: Detector(connector), m_connManager(NULL) {
	
	m_connManager = ConnectionManager::self();
	connect(m_connManager, TQT_SIGNAL(statusChanged(const TQString&, NetworktqStatus::EnumtqStatus)),
			this, TQT_SLOT(statusChanged(const TQString&, NetworktqStatus::EnumtqStatus)));
}

DetectorNetworktqStatus::~DetectorNetworktqStatus() {}

void DetectorNetworktqStatus::checktqStatus() const {
	// needs to do nothing
}

void DetectorNetworktqStatus::statusChanged(const TQString& host, NetworktqStatus::EnumtqStatus status) {
	switch(status) {
		case NetworktqStatus::Offline:
			kdDebug(14312) << k_funcinfo << host << ": NetworkStatus::Offline" << endl;
			break;
		case NetworktqStatus::OfflineFailed:
			kdDebug(14312) << k_funcinfo << host << ": NetworkStatus::OfflineFailed" << endl;
			break;
		case NetworktqStatus::OfflineDisconnected:
			kdDebug(14312) << k_funcinfo << host << ": NetworkStatus::OfflineDisconnected" << endl;
			break;
		case NetworktqStatus::ShuttingDown:
			kdDebug(14312) << k_funcinfo << host << ": NetworkStatus::ShuttingDown" << endl;
			break;
		case NetworktqStatus::Establishing:
			kdDebug(14312) << k_funcinfo << host << ": NetworkStatus::Establishing" << endl;
			break;
		case NetworktqStatus::Online:
			kdDebug(14312) << k_funcinfo << host << ": NetworkStatus::Online" << endl;
			break;
		case NetworktqStatus::NoNetworks:
			kdDebug(14312) << k_funcinfo << host << ": NetworkStatus::NoNetworks" << endl;
			break;
		case NetworktqStatus::Unreachable:
			kdDebug(14312) << k_funcinfo << host << ": NetworkStatus::Unreachable" << endl;
			break;
	}
}

#include "detectornetworkstatus.moc"
