/*
    webcamwidget.h - A simple widget for displaying webcam frames

    Copyright (c) 2006 by Gustavo Pichorim Boiko   <gustavo.boiko@kdemail.net>
    Kopete    (c) 2002-2006 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "webcamwidget.h"

#include <tqcolor.h>
#include <tqpainter.h>

#include <kdebug.h>
namespace Kopete
{

WebcamWidget::WebcamWidget( TQWidget* parent, const char* name )
: TQWidget( parent, name )
{
	clear();
}

WebcamWidget::~WebcamWidget()
{
	// don't do anything either
}

void WebcamWidget::updatePixmap(const TQPixmap& pixmap)
{
	mPixmap = pixmap;
	mText = "";

	TQPaintEvent *ev = new TQPaintEvent( rect(), true );
	paintEvent( ev );
	delete ev;
}

void WebcamWidget::clear()
{
	mText = "";
	if (!mPixmap.isNull())
		mPixmap.resize(0,0);
	
	TQPaintEvent *ev = new TQPaintEvent( rect(), true );
	paintEvent( ev );
	delete ev;
}

void WebcamWidget::setText(const TQString& text)
{
	mText = text;

	// for now redraw everything
	TQPaintEvent *ev = new TQPaintEvent( rect(), true );
        paintEvent( ev );
        delete ev;
}

void WebcamWidget::paintEvent( TQPaintEvent* event )
{
	TQMemArray<TQRect> rects = TQRegion(event->region()).tqrects();

	if (!mPixmap.isNull())
	{
		for (unsigned int i = 0; i < rects.count(); ++i)
		{
			bitBlt(TQT_TQPAINTDEVICE(this), rects[i].topLeft(), TQT_TQPAINTDEVICE(&mPixmap), rects[i], TQt::CopyROP, true);
		}
	}
	else
	{
		for (unsigned int i = 0; i < rects.count(); ++i)
		{
			TQColor bgColor = paletteBackgroundColor();
			TQPainter p(this);
			p.fillRect(rects[i], bgColor);
		}
	}

	// TODO: draw the text
	TQPainter p(this);
	TQRect r = p.boundingRect(rect(), TQt::AlignCenter | TQt::WordBreak, mText );
	if ( !mText.isEmpty() && event->rect().intersects(r))
	{
		p.setPen(TQt::black);
		TQRect rec = rect();
		rec.moveTopLeft(TQPoint(1,1));
		p.drawText(rec, TQt::AlignCenter | TQt::WordBreak, mText, -1); 

		rec.moveTopLeft(TQPoint(-1,-1));
		p.setPen(TQt::white);
		p.drawText(rec, TQt::AlignCenter | TQt::WordBreak, mText, -1); 
	}
}

} // end namespace Kopete

#include "webcamwidget.moc"
