/*
    kopeteplugin.cpp - Kopete Plugin API

    Copyright (c) 2001-2002 by Duncan Mac-Vicar P. <duncan@kde.org>
    Copyright (c) 2002-2004 by Olivier Goffart  <ogoffart @tiscalinet.be>

    Copyright (c) 2002-2004 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "kopeteplugin.h"
#include "kopetepluginmanager.h"

#include <kplugininfo.h>
#include <ksettings/dispatcher.h>
#include <kplugininfo.h>

namespace Kopete {

class Plugin::Private
{
public:
	TQStringList addressBookFields;
	TQString indexField;
};

Plugin::Plugin( KInstance *instance, TQObject *parent, const char *name )
: TQObject( parent, name ), KXMLGUIClient(), d(new Private)
{
	setInstance( instance );
	KSettings::Dispatcher::self()->registerInstance( instance, this, TQT_SIGNAL( settingsChanged() ) );
}

Plugin::~Plugin()
{
	delete d;
}

TQString Plugin::pluginId() const
{
	return TQString::tqfromLatin1( className() );
}


TQString Plugin::displayName() const
{
	return pluginInfo() ? pluginInfo()->name() : TQString();
}

TQString Plugin::pluginIcon() const
{
	return pluginInfo() ? pluginInfo()->icon() : TQString();
}


KPluginInfo *Plugin::pluginInfo() const 
{
	return PluginManager::self()->pluginInfo( this );
}

void Plugin::aboutToUnload()
{
	// Just make the unload synchronous by default
	emit readyForUnload();
}


void Plugin::deserialize( MetaContact * /* metaContact */,
	const TQMap<TQString, TQString> & /* stream */ )
{
	// Do nothing in default implementation
}



void Kopete::Plugin::addAddressBookField( const TQString &field, AddressBookFieldAddMode mode )
{
	d->addressBookFields.append( field );
	if( mode == MakeIndexField )
		d->indexField = field;
}

TQStringList Kopete::Plugin::addressBookFields() const
{
	return d->addressBookFields;
}

TQString Kopete::Plugin::addressBookIndexField() const
{
	return d->indexField;
	
}


void Plugin::virtual_hook( uint, void * ) { }

} //END namespace Kopete


#include "kopeteplugin.moc"


