/*
    kopetepasswordedaccount.cpp - Kopete Account with a password

    Copyright (c) 2004      by Richard Smith         <kde@metafoo.co.uk>
    Kopete    (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "kopetepasswordedaccount.h"
#include "kopetepassword.h"
#include "kopeteprotocol.h"
#include "kopeteonlinestatus.h"

#include <klocale.h>

#include <tqpixmap.h>

struct Kopete::PasswordedAccount::Private
{
	Private( const TQString &group, uint maxLen, bool allowBlankPassword ) :
		password( group, maxLen, allowBlankPassword, "mPassword" ) {}
	Kopete::Password password;
	Kopete::OnlineStatus initialtqStatus;
};

Kopete::PasswordedAccount::PasswordedAccount( Kopete::Protocol *parent, const TQString &acctId, uint maxLen, const char *name )
 : Kopete::Account( parent, acctId, name ), d( new Private( TQString::tqfromLatin1("Account_")+ parent->pluginId() + TQString::tqfromLatin1("_") + acctId , maxLen, false ) )
{
}

Kopete::PasswordedAccount::PasswordedAccount( Kopete::Protocol *parent, const TQString &acctId, uint maxLen,
	bool allowBlankPassword, const char *name )
 : Kopete::Account( parent, acctId, name ), d( new Private( TQString::tqfromLatin1("Account_")+ parent->pluginId() + TQString::tqfromLatin1("_") + acctId , maxLen, allowBlankPassword ) )
{
}

Kopete::PasswordedAccount::~PasswordedAccount()
{
	delete d;
}

Kopete::Password &Kopete::PasswordedAccount::password()
{
	return d->password;
}

void Kopete::PasswordedAccount::connect( )
{
	Kopete::OnlineStatus s(Kopete::OnlineStatus::Online);
	connect( s );
}

void Kopete::PasswordedAccount::connect( const Kopete::OnlineStatus& initialtqStatus )
{
	// check that the networkstatus is up

	// warn user somewhere
	d->initialtqStatus = initialtqStatus;
	TQString cached = password().cachedValue();
	if( !cached.isNull() || d->password.allowBlankPassword() )
	{
		connectWithPassword( cached );
		return;
	}

	TQString prompt = passwordPrompt();
	Kopete::Password::PasswordSource src = password().isWrong() ? Kopete::Password::FromUser : Kopete::Password::FromConfigOrUser;

	password().request( this, TQT_SLOT( connectWithPassword( const TQString & ) ), accountIcon( Kopete::Password::preferredImageSize() ), prompt, src );
}

TQString Kopete::PasswordedAccount::passwordPrompt()
{
	if ( password().isWrong() )
		return i18n( "<b>The password was wrong;</b> please re-enter your password for %1 account <b>%2</b>" ).tqarg( protocol()->displayName(), accountId() );
	else
		return i18n( "Please enter your password for %1 account <b>%2</b>" ).tqarg( protocol()->displayName(), accountId() );
}

Kopete::OnlineStatus Kopete::PasswordedAccount::initialtqStatus()
{
	return d->initialtqStatus;
}

bool Kopete::PasswordedAccount::removeAccount()
{
	password().set(TQString());
	return Kopete::Account::removeAccount();
}

void Kopete::PasswordedAccount::disconnected( Kopete::Account::DisconnectReason reason )
{
	if(reason==Kopete::Account::BadPassword || reason==Kopete::Account::BadUserName)
	{
		password().setWrong(true);
	}
	Kopete::Account::disconnected(reason);
}


#include "kopetepasswordedaccount.moc"

// vim: set noet ts=4 sts=4 sw=4:
