/*
    kopetenotifydataobject.cpp - Container for notification events

    Copyright (c) 2004 by Will Stephenson     <lists@stevello.free-online.co.uk>

    Kopete    (c) 2002-2004 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include <tqdom.h>
#include <kdebug.h>
#include "kopetenotifydataobject.h"
#include "kopetenotifyevent.h"

class Kopete::NotifyDataObject::Private
{
public:
	TQDict<Kopete::NotifyEvent> events;
};

Kopete::NotifyDataObject::NotifyDataObject()
{
	d = new Private();
	d->events.setAutoDelete( true );
}

Kopete::NotifyDataObject::~NotifyDataObject()
{
	delete d;
}

Kopete::NotifyEvent * Kopete::NotifyDataObject::notifyEvent( const TQString &event ) const
{
	Kopete::NotifyEvent *evt = d->events.find( event );
	return evt;
}

void Kopete::NotifyDataObject::setNotifyEvent( const TQString& event, Kopete::NotifyEvent *notifyEvent )
{
	d->events.replace( event, notifyEvent );
}

bool Kopete::NotifyDataObject::removeNotifyEvent( const TQString &event )
{
	return d->events.remove( event );
}

TQDomElement Kopete::NotifyDataObject::notifyDataToXML()
{
	TQDomDocument notify;
	TQDomElement notifications;
	if ( !d->events.isEmpty() )
	{
		//<custom-notifications>
		notifications = notify.createElement( TQString::tqfromLatin1( "custom-notifications" ) );
		TQDictIterator<Kopete::NotifyEvent> it( d->events );
		for ( ; it.current(); ++it )
		{
			//<event name="..." suppress-common="true|false">
			TQDomElement event = notify.createElement( TQString::tqfromLatin1( "event" ) );
			event.setAttribute( TQString::tqfromLatin1( "name" ), it.currentKey() );
			event.setAttribute( TQString::tqfromLatin1( "suppress-common" ), TQString::tqfromLatin1( it.current()->suppressCommon() ? "true" : "false" ) );
			TQValueList<TQDomElement> presentations = it.current()->toXML();
			//<sound-notification enabled="true|false" src="..." single-shot="">
			for ( TQValueList<TQDomElement>::Iterator it = presentations.begin(); it != presentations.end(); ++it )
				event.appendChild( notify.importNode( *it, true ) );
			notifications.appendChild( event );
		}
	}
	return notifications;
}

bool Kopete::NotifyDataObject::notifyDataFromXML( const TQDomElement& element )
{
	if ( element.tagName() == TQString::tqfromLatin1( "custom-notifications" ) )
	{
		TQDomNode field = element.firstChild();
		while( !field.isNull() )
		{
			//read an event
			TQDomElement fieldElement = field.toElement();
			if ( fieldElement.tagName() == TQString::tqfromLatin1( "event" ) )
			{
				// get its attributes
				TQString name = fieldElement.attribute( TQString::tqfromLatin1( "name" ), TQString() );
				TQString suppress = fieldElement.attribute( TQString::tqfromLatin1( "suppress-common" ), TQString() );
				Kopete::NotifyEvent *evt = new Kopete::NotifyEvent( suppress == TQString::tqfromLatin1( "true" ) );
			
				// get its tqchildren
				TQDomNode child = fieldElement.firstChild();
				while( !child.isNull() )
				{
					TQDomElement childElement = child.toElement();
					if ( childElement.tagName() == TQString::tqfromLatin1( "sound-presentation" ) )
					{
//						kdDebug(14010) << k_funcinfo << "read: sound" << endl;
						TQString src = childElement.attribute( TQString::tqfromLatin1( "src" ) );
						TQString enabled = childElement.attribute( TQString::tqfromLatin1( "enabled" ) );
						TQString singleShot = childElement.attribute( TQString::tqfromLatin1( "single-shot" ) );
						Kopete::EventPresentation *pres = new Kopete::EventPresentation( Kopete::EventPresentation::Sound, src,
								( singleShot == TQString::tqfromLatin1( "true" ) ),
								( enabled == TQString::tqfromLatin1( "true" ) ) );
						evt->setPresentation( Kopete::EventPresentation::Sound, pres );
// 						kdDebug(14010) << k_funcinfo << "after sound: " << evt->toString() << endl;
					}
					if ( childElement.tagName() == TQString::tqfromLatin1( "message-presentation" ) )
					{
// 						kdDebug(14010) << k_funcinfo << "read: msg" << endl;
						TQString src = childElement.attribute( TQString::tqfromLatin1( "src" ) );
						TQString enabled = childElement.attribute( TQString::tqfromLatin1( "enabled" ) );
						TQString singleShot = childElement.attribute( TQString::tqfromLatin1( "single-shot" ) );
						Kopete::EventPresentation *pres = new Kopete::EventPresentation(  Kopete::EventPresentation::Message, src,
								( singleShot == TQString::tqfromLatin1( "true" ) ),
								( enabled == TQString::tqfromLatin1( "true" ) ) );
						evt->setPresentation( Kopete::EventPresentation::Message, pres );
// 						kdDebug(14010) << k_funcinfo << "after message: " << evt->toString() << endl;
					}
					if ( childElement.tagName() == TQString::tqfromLatin1( "chat-presentation" ) )
					{
// 						kdDebug(14010) << k_funcinfo << "read: chat" << endl;
						TQString enabled = childElement.attribute( TQString::tqfromLatin1( "enabled" ) );
						TQString singleShot = childElement.attribute( TQString::tqfromLatin1( "single-shot" ) );
						Kopete::EventPresentation *pres = new Kopete::EventPresentation( Kopete::EventPresentation::Chat, TQString(),
								( singleShot == TQString::tqfromLatin1( "true" ) ),
								( enabled == TQString::tqfromLatin1( "true" ) ) );
						evt->setPresentation( Kopete::EventPresentation::Chat, pres );
// 						kdDebug(14010) << k_funcinfo << "after chat: " << evt->toString() << endl;
					}
					child = child.nextSibling();
				}
// 				kdDebug(14010) << k_funcinfo << "read: " << evt->toString() << endl;
				setNotifyEvent( name, evt );
			}
			field = field.nextSibling();
		}
		return true;
	}
	else
	{
		kdDebug( 14010 ) << "element wasn't custom-notifications" << endl;
		return false;
	}
}

