/*
    kopeteblacklister.cpp - Kopete BlackLister

    Copyright (c) 2004      by Roie Kerstein         <sf_kersteinroie@bezeqint.net>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "kopeteblacklister.h"

#include "kopetecontact.h"

#include <kconfig.h>
#include <kglobal.h>

#include <tqstringlist.h>

namespace Kopete
{

class BlackLister::Private
{
public:
	TQStringList blacklist;
	TQString owner;
	TQString protocol;
};


BlackLister::BlackLister(const TQString &protocolId, const TQString &accountId, TQObject *parent, const char *name)
 : TQObject(parent, name), d( new Private )
{
	KConfig *config = KGlobal::config();
	
	d->owner = accountId;
	d->protocol = protocolId;
	config->setGroup("BlackLister");
	d->blacklist = config->readListEntry( d->protocol + TQString::tqfromLatin1("_") + d->owner );
}

BlackLister::~BlackLister()
{
	delete d;
}


bool BlackLister::isBlocked(const TQString &contactId)
{
	return (d->blacklist.find( contactId ) != d->blacklist.end() );
}

bool BlackLister::isBlocked(Contact *contact)
{
	return isBlocked(contact->contactId());
}

void BlackLister::addContact(const TQString &contactId)
{
	if( !isBlocked(contactId) )
	{
		d->blacklist += contactId;
		saveToDisk();
		emit contactAdded( contactId );
	}
}

void BlackLister::addContact(Contact *contact)
{
	TQString temp = contact->contactId();
	
	addContact( temp );
}

void BlackLister::removeContact(Contact *contact)
{
	TQString temp = contact->contactId();
	
	removeContact( temp );
}

void BlackLister::saveToDisk()
{
	KConfig *config = KGlobal::config();
	
	config->setGroup("BlackLister");
	config->writeEntry( d->protocol + TQString::tqfromLatin1("_") + d->owner, d->blacklist );
	config->sync();
}

void BlackLister::removeContact(const TQString &contactId)
{
	if( isBlocked(contactId) )
	{
		d->blacklist.remove( contactId );
		saveToDisk();
		emit contactRemoved( contactId );
	}
}

}

#include "kopeteblacklister.moc"
