/*
    ChatWindowStyle test suite

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <kunittest/module.h>
#include "chatwindowstyle_test.h"

#include <stdlib.h>

#include <tqdir.h>
#include <tqfile.h>

#include <kopetechatwindowstyle.h>

KUNITTEST_MODULE( kunittest_chatwindowstyle_test, "KopeteChatWindowTestSuite");
KUNITTEST_MODULE_REGISTER_TESTER( ChatWindowStyle_Test );

void ChatWindowStyle_Test::allTests()
{
	testStyle = new ChatWindowStyle(TQString(SRCDIR)+TQString("/TestStyle"));

	// change user data dir to avoid messing with user's .kde dir
	setenv( "KDEHOME", TQFile::encodeName( TQDir::homeDirPath() + "/.kopete-unittest" ), true );

	testPaths();
	testHtml();
	testVariants();
	testAction();
}

void ChatWindowStyle_Test::testPaths()
{
	TQString expectedStylePath = SRCDIR + TQString::fromUtf8("/TestStyle");
	TQString expectedBaseHref = expectedStylePath + TQString::fromUtf8("/Contents/Resources/");

	CHECK(testStyle->getStylePath(), expectedStylePath);
	CHECK(testStyle->getStyleBaseHref(), expectedBaseHref);
}

void ChatWindowStyle_Test::testHtml()
{
	TQString exceptedHeader = TQString::fromUtf8(
"<div>%chatName%</div>\n"
"<div>%sourceName%</div>\n"
"<div>%destinationName%</div>\n"
"<div>%incomingIconPath%</div>\n"
"<div>%outgoingIconPath%</div>\n"
"<div>%timeOpened%</div>\n"
"<div>%timeOpened{%H:%M}%</div>");
	// Footer is empty on purpose, this is to test if the file doesn't exist.
	TQString exceptedFooter;
	TQString exceptedIncoming = TQString::fromUtf8(
"Incoming:\n"
"<div>%userIconPath%</div>\n"
"<div>%senderScreenName%</div>\n"
"<div>%sender%</div>\n"
"<div>%service%</div>\n"
"<div>%message%</div>\n"
"<div>%time%</div>\n"
"<div>%time{%H:%M}%</div>\n"
"<div id=\"insert\">");
	TQString exceptedNextIncoming = TQString::fromUtf8(
"Incoming:\n"
"<div>%message%</div>\n"
"<div id=\"insert\">"
);
	TQString exceptedOutgoing = TQString::fromUtf8(
"Outgoing:\n"
"<div>%userIconPath%</div>\n"
"<div>%senderScreenName%</div>\n"
"<div>%sender%</div>\n"
"<div>%service%</div>\n"
"<div>%message%</div>\n"
"<div>%time%</div>\n"
"<div>%time{%H:%M}%</div>\n"
"<div id=\"insert\">");
	TQString exceptedNextOutgoing = TQString::fromUtf8(
"Outgoing:\n"
"<div>%message%</div>\n"
"<div id=\"insert\">"
);
	TQString exceptedtqStatus = TQString::fromUtf8(
"<div>%message%</div>\n"
"<div>%time%</div>\n"
"<div>%time{%H:%M}%</div>");

	CHECK(testStyle->getHeaderHtml(), exceptedHeader);
	CHECK(testStyle->getFooterHtml(), exceptedFooter);
	CHECK(testStyle->getIncomingHtml(), exceptedIncoming);
	CHECK(testStyle->getNextIncomingHtml(), exceptedNextIncoming);
	CHECK(testStyle->getOutgoingHtml(), exceptedOutgoing);
	CHECK(testStyle->getNextOutgoingHtml(), exceptedNextOutgoing);
	CHECK(testStyle->getStatusHtml(), exceptedtqStatus);
}

void ChatWindowStyle_Test::testAction()
{
	CHECK(testStyle->hasActionTemplate(), false);
}

void ChatWindowStyle_Test::testVariants()
{
	TQString expectedNameResult("Variant1;Variant2");
	TQString expectedPathResult("Variants/Variant1.css;Variants/Variant2.css");
	TQStringList variantNameList;
	TQStringList variantPathList;
	ChatWindowStyle::StyleVariants variantList;
	ChatWindowStyle::StyleVariants::ConstIterator it;
	variantList = testStyle->getVariants();

	for(it = variantList.constBegin(); it != variantList.constEnd(); ++it)
	{
		variantNameList.append(it.key());
		variantPathList.append(it.data());
	}	
	
	CHECK(variantNameList.join(";"), expectedNameResult);
	CHECK(variantPathList.join(";"), expectedPathResult);
}
