#include "kget_linkview.h"

#include <tqlayout.h>

#include <dcopclient.h>
#include <kaction.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <klistviewsearchline.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <kstdaction.h>
#include <ktoolbar.h>

#define COL_NAME 0
#define COL_DESC 1
#define COL_MIME 2
#define COL_URL  3

LinkViewItem::LinkViewItem( TQListView *parent, const LinkItem *lnk )
    : TQListViewItem( parent ),
      link( lnk )
{
    TQString file = link->url.fileName();
    if ( file.isEmpty() )
        file = link->url.host();

    setPixmap( COL_NAME, SmallIcon( link->icon ) );
    setText( COL_NAME, file );

    setText( COL_DESC, link->text );
    setText( COL_MIME, link->mimeType );
    setText( COL_URL,  link->url.prettyURL() );
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

KGetLinkView::KGetLinkView( TQWidget *parent, const char *name )
    : KMainWindow( parent, name )
{
    setPlainCaption( i18n( "KGet" ) );

    KAction* actionDownload = new KAction( i18n("Download Selected Files"),
                                           "kget", CTRL+Key_D,
                                           TQT_TQOBJECT(this), TQT_SLOT( slotStartLeech() ),
                                           actionCollection(), "startDownload" );

    KAction* actionSelectAll = KStdAction::selectAll( TQT_TQOBJECT(this), TQT_SLOT( slotSelectAll() ),
                                                      actionCollection() );

    m_links.setAutoDelete( true );
    actionDownload->plug( toolBar() );
    toolBar()->insertLineSeparator();
    actionSelectAll->plug( toolBar() );

    TQWidget *mainWidget = new TQWidget( this );
    TQVBoxLayout *tqlayout = new TQVBoxLayout( mainWidget );
    setCentralWidget( mainWidget );

    m_view = new KListView( mainWidget, "listview" );
    m_view->setSelectionMode( TQListView::Extended );
    m_view->addColumn( i18n("File Name") );
    m_view->addColumn( i18n("Description") );
    m_view->addColumn( i18n("File Type") );
    m_view->addColumn( i18n("Location (URL)") );
    m_view->setShowSortIndicator( true );

    KListViewSearchLineWidget *line = new KListViewSearchLineWidget( m_view, mainWidget, "search line" );
    tqlayout->addWidget( line );
    tqlayout->addWidget( m_view );

    // setting a fixed (not floating) toolbar
    toolBar()->setMovingEnabled( false );
    // setting Text next to Icons
    toolBar()->setIconText( KToolBar::IconTextRight );
}

KGetLinkView::~KGetLinkView()
{
}

void KGetLinkView::setLinks( TQPtrList<LinkItem>& links )
{
    m_links = links; // now we 0wn them
    showLinks( m_links );
}

void KGetLinkView::showLinks( const TQPtrList<LinkItem>& links )
{
    m_view->clear();

    TQPtrListIterator<LinkItem> it( links );
    for ( ; it.current(); ++it )
        (void) new LinkViewItem( m_view, *it );

    m_view->sort();
}

void KGetLinkView::slotStartLeech()
{
    KURL::List urls;
    TQListViewItemIterator it( m_view->firstChild() );
    for ( ; it.current(); ++it )
    {
        if ( it.current()->isSelected() )
            urls.append( static_cast<LinkViewItem*>( it.current() )->link->url );
    }

    if ( urls.isEmpty() )
        KMessageBox::sorry( this,
                            i18n("You did not select any files to download."),
                            i18n("No Files Selected") );
    else
    {
        DCOPClient* p_dcopServer = new DCOPClient();
        p_dcopServer->attach();

        if ( !p_dcopServer->isApplicationRegistered( "kget" ) )
        {
            KApplication::startServiceByDesktopName( "kget" );
        }
        kapp->updateRemoteUserTimestamp( "kget" );

        TQByteArray data;
        TQDataStream stream( data, IO_WriteOnly );
        stream << urls << TQString();
        bool ok = DCOPClient::mainClient()->send( "kget", "KGet-Interface",
                                                  "addTransfers(KURL::List, TQString)",
                                                  data );

        kdDebug() << "*** startDownload: " << ok << endl;

        p_dcopServer->detach();
        delete p_dcopServer;
    }
}

void KGetLinkView::setPageURL( const TQString& url )
{
    setPlainCaption( i18n( "Links in: %1 - KGet" ).tqarg( url ) );
}

void KGetLinkView::slotSelectAll()
{
    m_view->selectAll( true );
}

#include "kget_linkview.moc"
