/* -------------------------------------------------------------

   queryview.h (part of The KDE Dictionary Client)

   Copyright (C) 2000-2001 Christian Gebauer <gebauer@kde.org>

   This file is distributed under the Artistic License.
   See LICENSE for details.

    -------------------------------------------------------------

    SaveHelper    network transparent file saving
    BrowseData    data structure used for caching definitions
    DictHTMLPart  handling of middle mouse button clicks
    QueryView     widget that displays the definitions

 ------------------------------------------------------------- */

#ifndef _TQUERYVIEW_H_
#define _TQUERYVIEW_H_

#include <tqvbox.h>
#include <khtml_part.h>

class TQFile;
class KTempFile;
class KPopupMenu;
class DictComboAction;


TQString getShortString(TQString str,unsigned int length);


//********  SaveHelper  *******************************************


class SaveHelper {

public:

  SaveHelper(const TQString &saveName, const TQString &filter, TQWidget *parent);
  ~SaveHelper();

  // returns a file open for writing
  TQFile* getFile(const TQString &dialogTitle);

private:

  TQWidget *p_arent;
  TQString s_aveName, f_ilter;
  KURL url;
  TQFile* file;
  KTempFile* tmpFile;
  static TQString lastPath;

};


//********  BrowseData  ******************************************


class BrowseData
{

public:

  BrowseData(const TQString &Nhtml, const TQString &NqueryText);

  TQString html;
  TQString queryText;
  int xPos,yPos;
};


//*********  DictHTMLPart  ***************************************

class DictHTMLPart : public KHTMLPart
{
  Q_OBJECT
  TQ_OBJECT

public:

  DictHTMLPart(TQWidget *parentWidget = 0, const char *widgetname = 0);
  ~DictHTMLPart();

signals:
  void middleButtonClicked();

protected:

  virtual void khtmlMouseReleaseEvent(khtml::MouseReleaseEvent *event);

};

//*********  QueryView  ******************************************


class QueryView : public TQVBox
{
  Q_OBJECT
  TQ_OBJECT

public:

  QueryView(TQWidget *_parent = 0L);
  ~QueryView();

  void setActions(KToolBarPopupAction* NactBack, KToolBarPopupAction* NactForward, DictComboAction* NactQueryCombo);

  bool browseBackPossible() const;
  bool browseForwardPossible() const;

  void stop();

public slots:
  void optionsChanged();
  void printQuery();
  void saveQuery();
  void browseBack();
  void browseForward();
  void selectAll();
  void copySelection();
  void showFindDialog();

signals:

  void defineRequested(const TQString &query);
  void matchRequested(const TQString &query);
  void clipboardRequested();
  void enableCopy(bool selected);   // emited when the user selects/deselects text
  void enablePrintSave();
  void renderingStarted();
  void renderingStopped();
  void newCaption(const TQString&);

protected:

  void paletteChange ( const TQPalette & );
  void fontChange ( const TQFont & );

  void saveCurrentResultPos();
  void showResult();

protected slots:

  void resultReady(const TQString &result, const TQString &query);
  void partCompleted();
  void slotURLRequest (const KURL &url, const KParts::URLArgs &args);
  void middleButtonClicked();
  void buildPopupMenu(const TQString &url, const TQPoint &point);
  void popupDefineLink();
  void popupMatchLink();
  void popupOpenLink();
  void popupDefineSelect();
  void popupMatchSelect();
  void popupDbInfo();
  void enableAction(const char *, bool);
  void browseBack(int);
  void browseForward(int);
  void updateBrowseActions();

private:

  DictHTMLPart *part;               // Widgets

  KToolBarPopupAction *actBack, *actForward;
  DictComboAction *actQueryCombo;

  KPopupMenu *rightBtnMenu;
  TQString popupLink,popupSelect;       // needed for rightbtn-popup menu

  TQPtrList<BrowseData> browseList;
  unsigned int browsePos;              // position in browseList
  TQString currentHTMLHeader;

  bool isRendering;
};

#endif
