/* -------------------------------------------------------------

   actions.h (part of The KDE Dictionary Client)

   Copyright (C) 2000-2001 Christian Gebauer <gebauer@kde.org>

   This file is distributed under the Artistic License.
   See LICENSE for details.

   -------------------------------------------------------------

   DictComboAction,            special KAction subclasses used
   DictLabelAction,            in the toolbar
   DictButtonAction

 ------------------------------------------------------------- */

#ifndef _ACTIONS_H_
#define _ACTIONS_H_

#include <tqguardedptr.h>
#include <tqptrlist.h>
#include <kaction.h>
#include <kglobalsettings.h>

class KComboBox;
class TQLabel;
class TQPushButton;


class DictComboAction : public KAction
{
  Q_OBJECT
  TQ_OBJECT

  public:
    DictComboAction( const TQString& text, TQObject* parent,
                     const char* name, bool editable, bool autoSized );
    ~DictComboAction();

    virtual int plug( TQWidget *w, int index = -1 );
    virtual void unplug( TQWidget *w );

    TQWidget* widget();
    void setFocus();

    TQString currentText() const;
    void selectAll();
    void setEditText(const TQString &s);
    void setCurrentItem(int index);
    void clearEdit();

    void clear();
    void setList(TQStringList items);

    KGlobalSettings::Completion completionMode();
    void setCompletionMode(KGlobalSettings::Completion mode);

  signals:
    void activated(int);
    void activated(const TQString&);

  private slots:
    void slotComboActivated(int);
    void slotComboActivated(const TQString&);

  private:
    TQGuardedPtr<KComboBox> m_combo;
    bool m_editable, m_autoSized;
    KGlobalSettings::Completion m_compMode;
};


class DictLabelAction : public KAction
{
  Q_OBJECT
  TQ_OBJECT

  public:
    DictLabelAction( const TQString &text, TQObject *parent = 0, const char *name = 0 );
    ~DictLabelAction();

    virtual int plug( TQWidget *widget, int index = -1 );
    virtual void unplug( TQWidget *widget );

    void setBuddy(TQWidget *buddy);

  private:
    TQGuardedPtr<TQLabel> m_label;

};


class DictButtonAction : public KAction
{
  Q_OBJECT
  TQ_OBJECT

  public:
    DictButtonAction( const TQString& text, TQObject* receiver,
                     const char* slot, TQObject* parent, const char* name );
    ~DictButtonAction();

    virtual int plug( TQWidget *w, int index = -1 );
    virtual void unplug( TQWidget *w );

    int widthHint();
    void setWidth(int width);

  private:
    TQGuardedPtr<TQPushButton> m_button;
};

#endif
