#include "find.h"
#include <tqlayout.h>
#include <kcombobox.h>
#include <tqpushbutton.h>
#include <tqcheckbox.h>
#include <klocale.h>

Finder::Finder(TQWidget *parent) : KDialogBase(parent, 0, false, i18n("Find"), Close | User1, User1, false, KGuiItem(i18n("&Find"),"find"))
{
	TQWidget *mainWidget = new TQWidget(this);
	mainWidget->setMinimumWidth(320);
	setMainWidget(mainWidget);

	TQGridLayout *tqlayout=new TQGridLayout(mainWidget);
	tqlayout->setSpacing(KDialog::spacingHint());

	mText=new KHistoryCombo(mainWidget);
	mText->setMaxCount(10);

	mText->setFocus();

	mRegexp=new TQCheckBox(i18n("&Regular expression"), mainWidget);
	mBackwards=new TQCheckBox(i18n("Find &backwards"), mainWidget);

	tqlayout->addMultiCellWidget(mText, 0, 0, 0, 1);
	tqlayout->addWidget(mRegexp, 1, 0);
	tqlayout->addWidget(mBackwards, 1, 1);

	connect(this, TQT_SIGNAL(user1Clicked()), TQT_SLOT(clicked()));

	connect(mText, TQT_SIGNAL(activated(int)), TQT_SLOT(clicked()));
	connect(mText, TQT_SIGNAL(textChanged(const TQString &)), TQT_SLOT(textChanged(const TQString &)));

	enableButton(User1, false);
}

void Finder::textChanged(const TQString &text) {
	enableButton(User1, !text.isEmpty());
}

bool Finder::regexp() const
{
	return mRegexp->isChecked();
}

bool Finder::isForward() const
{
	return !mBackwards->isChecked();
}

void Finder::clicked()
{
	mText->addToHistory( mText->currentText() );
	emit search(this);
}

TQString Finder::string() const
{
	return mText->currentText();
}


#include "find.moc"
