#ifndef KJETQUALIZER_H
#define KJETQUALIZER_H

#include "kjwidget.h"
//#include "kjloader.h"
class KJLoader;
class VInterpolation;

#include <tqobject.h>

class KJEqualizer : public TQObject, public KJWidget
{
Q_OBJECT
  TQ_OBJECT
public:
	KJEqualizer(const TQStringList &, KJLoader *parent);
	~KJEqualizer(void);

	virtual void mouseMove(const TQPoint &pos, bool);
	virtual bool mousePress(const TQPoint&);
	virtual void paint(TQPainter *p, const TQRect &rect);
	int barNum(const TQPoint &pos) const;
	int level(const TQPoint &pos) const;

public slots:
	void slotUpdateBuffer();

private:
	int mBands;
	int mXSpace;

	int mBandWidth;
	int mBandHalfHeight;
	TQPixmap mBars; // holds all slider images
	TQPixmap *mBack; // holds background of EQ for easy tqrepaint
	TQPixmap *mView; // holds prepared img of all sliders
	VInterpolation *mInterpEq;
};

#endif
