#include <noatun/controls.h>

L33tSlider::L33tSlider(TQWidget * parent, const char * name) :
	TQSlider(parent,name), pressed(false)
{}
L33tSlider::L33tSlider(Qt::Orientation o, TQWidget * parent, const char * name) :
	TQSlider(o,parent,name), pressed(false)
{}
L33tSlider::L33tSlider(int minValue, int maxValue, int pageStep, int value,
	                   Qt::Orientation o, TQWidget * parent, const char * name) :
	TQSlider(minValue, maxValue, pageStep, value, o, parent,name), pressed(false)
{}

bool L33tSlider::currentlyPressed() const
{
	return pressed;
}

void L33tSlider::setValue(int i)
{
	if (!pressed)
		TQSlider::setValue(i);
}

void L33tSlider::mousePressEvent(TQMouseEvent*e)
{
	if (e->button()!=Qt::RightButton)
	{
		pressed=true;
		TQSlider::mousePressEvent(e);
	}
}

void L33tSlider::mouseReleaseEvent(TQMouseEvent*e)
{
	pressed=false;
	TQSlider::mouseReleaseEvent(e);
	emit userChanged(value());
}

void L33tSlider::wheelEvent(TQWheelEvent *e)
{
	TQSlider::wheelEvent(e);
	int newValue=value() /* +e->delta()/120 */;
	if (newValue<minValue())
		newValue=minValue();
	else if (newValue>maxValue())
		newValue=maxValue();
	setValue(newValue);
	emit userChanged(newValue);
}


SliderAction::SliderAction(const TQString& text, int accel, const TQObject *receiver,
                                 const char *member, TQObject* parent, const char* name )
	: KAction( text, accel, parent, name )
{
	m_receiver = receiver;
	m_member = member;
}

int SliderAction::plug( TQWidget *w, int index )
{
	if (!w->inherits("KToolBar")) return -1;

	KToolBar *toolBar = (KToolBar *)w;
	int id = KAction::getToolButtonID();
	
	//Create it.
	m_slider=new L33tSlider(0, 1000, 100, 0,Qt::Horizontal, toolBar);
	m_slider->setMinimumWidth(10);
	toolBar->insertWidget(id, 10, m_slider, index );


	addContainer( toolBar, id );
	connect( toolBar, TQT_SIGNAL( destroyed() ), this, TQT_SLOT( slotDestroyed() ) );
	toolBar->setItemAutoSized( id, true );

	if (w->inherits( "KToolBar" ))
		connect(toolBar, TQT_SIGNAL(moved(KToolBar::BarPosition)), this, TQT_SLOT(toolbarMoved(KToolBar::BarPosition)));
	
	emit plugged();

	return containerCount() - 1;
}

void SliderAction::toolbarMoved(KToolBar::BarPosition)
{
// I wish this worked :)
return;	
/*
	if (pos == KToolBar::Left || pos == KToolBar::Right)
	{
		m_slider->setOrientationVertical);
		m_slider->setFixedWidth(m_slider->height());
	}
	else
	{
		m_slider->setOrientationHorizontal);
		m_slider->resize(m_slider->height(), m_slider->height());
	}
*/
}

void SliderAction::unplug( TQWidget *w )
{
	KToolBar *toolBar = (KToolBar *)w;
	int idx = findContainer( w );

	toolBar->removeItem( menuId( idx ) );
	removeContainer( idx );
}

#include "controls.moc"
