#include <cmodule.h>
#include <noatun/pluginloader.h>
#include <common.h>
#include <noatun/app.h>

#include <tqpushbutton.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <klocale.h>
#include <kdebug.h>
#include <klistview.h>
#include <tqsplitter.h>
#include <tqlabel.h>
#include <tqdragobject.h>
#include <kurlrequester.h>
#include <kfiledialog.h>
#include <kdialog.h>
#include <klineedit.h>

#include <tqtextview.h>
#include <tqwhatsthis.h>

#include "mimetypetree.h"

/*****************************************************************
 * General options
 *****************************************************************/

General::General(TQObject *parent)
	: CModule(i18n("General"), i18n("General Options"), "configure", parent)
{
	mLoopList=new TQCheckBox(i18n("&Return to start of playlist on finish"), this);
	mLoopList->setChecked(napp->loopList());
	TQWhatsThis::add(mLoopList, i18n("When the playlist is finished playing, return to the start, but do not start playing."));

	mOneInstance=new TQCheckBox(i18n("Allow only one &instance of Noatun"), this);
	mOneInstance->setChecked(napp->oneInstance());
	TQWhatsThis::add(mOneInstance, i18n("Starting noatun a second time will cause it to just append items from the start to the current instance."));

	mClearOnOpen = new TQCheckBox(i18n("Clear playlist &when opening a file"), this);
	mClearOnOpen->setChecked(napp->clearOnOpen());
	TQWhatsThis::add(mClearOnOpen, i18n("Opening a file with the global Open menu item will clear the playlist first."));

	mFastVolume=new TQCheckBox(i18n("&Use fast hardware volume control"), this);
	mFastVolume->setChecked(napp->fastMixer());
	TQWhatsThis::add(mFastVolume, i18n("Use the hardware mixer instead of aRts'. It affects all streams, not just Noatun's, but is a little faster."));

	mRemaining=new TQCheckBox(i18n("Display &remaining play time"), this);
	mRemaining->setChecked(napp->displayRemaining());
	TQWhatsThis::add(mRemaining, i18n("Counters count down towards zero, showing remaining time instead of elapsed time."));

	TQLabel *titleLabel=new TQLabel(i18n("Title &format:"), this);
	mTitleFormat=new KLineEdit(this);
	titleLabel->setBuddy(mTitleFormat);
	mTitleFormat->setText(napp->titleFormat());
	TQWhatsThis::add(mTitleFormat, i18n(
			"Select a title to use for each file (in the playlist and user interface). "
			"Each element such as $(title) is replaced with the property with the name "
			"as given in the parentheses. The properties include, but are not limited to: "
			"title, author, date, comments and album."));

	TQLabel *dlsaver=new TQLabel(i18n("&Download folder:"), this);
	mDlSaver=new KURLRequester(napp->saveDirectory(), this);
	dlsaver->setBuddy(mDlSaver);
	connect( mDlSaver, TQT_SIGNAL( openFileDialog( KURLRequester * )),
		 this, TQT_SLOT( slotRequesterClicked( KURLRequester * )));
	TQWhatsThis::add(mDlSaver, i18n("When opening a non-local file, download it to the selected folder."));

	mPlayOnStartup = new TQButtonGroup(1,Qt::Horizontal, i18n("Play Behavior on Startup"), this);
	mPlayOnStartup->setExclusive(true);
	mPlayOnStartup->insert(
			new TQRadioButton(i18n("Restore &play state"), mPlayOnStartup),
			NoatunApp::Restore
		);
	mPlayOnStartup->insert(
			new TQRadioButton(i18n("Automatically play &first file"), mPlayOnStartup),
			NoatunApp::Play
		);
	mPlayOnStartup->insert(
			new TQRadioButton(i18n("&Do not start playing"), mPlayOnStartup),
			NoatunApp::DontPlay
		);

	if (TQButton* b = mPlayOnStartup->find(napp->startupPlayMode()))
	{
		b->toggle();
	}

	TQGridLayout *tqlayout = new TQGridLayout(this, 0, KDialog::spacingHint());
	tqlayout->setSpacing(KDialog::spacingHint());

	tqlayout->addMultiCellWidget(mLoopList, 0, 0, 0, 1);
	tqlayout->addMultiCellWidget(mOneInstance, 2, 2, 0, 1);
	tqlayout->addMultiCellWidget(mClearOnOpen, 4, 4, 0, 1);
	tqlayout->addMultiCellWidget(mFastVolume, 5, 5, 0, 1);
	tqlayout->addMultiCellWidget(mRemaining, 6, 6, 0, 1);

	tqlayout->addWidget(titleLabel, 7, 0);
	tqlayout->addWidget(mTitleFormat, 7, 1);

	tqlayout->addWidget(dlsaver, 8, 0);
	tqlayout->addWidget(mDlSaver, 8, 1);

	tqlayout->addMultiCellWidget(mPlayOnStartup, 9, 9, 0, 1);

	tqlayout->setRowStretch(10, 1);
}


void General::save()
{
	napp->setLoopList(mLoopList->isChecked());
	napp->setOneInstance(mOneInstance->isChecked());
	napp->setClearOnOpen(mClearOnOpen->isChecked());
	napp->setSaveDirectory(mDlSaver->url());
	napp->setFastMixer(mFastVolume->isChecked());
	napp->setTitleFormat(mTitleFormat->text());
	napp->setDisplayRemaining(mRemaining->isChecked());
	napp->setStartupPlayMode(mPlayOnStartup->selectedId());
}


void General::slotRequesterClicked( KURLRequester * )
{
	mDlSaver->fileDialog()->setMode(
		(KFile::Mode)(KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly));
}

#include "cmodule.moc"
