/***************************************************************************
    copyright            : (C) 2003 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#include "krecnewproperties.h"
#include "krecnewproperties.moc"

#include "krecglobal.h"
#include "krecconfig_fileswidget.h"

#include <kconfig.h>
#include <tqbuttongroup.h>
#include <tqvbuttongroup.h>
#include <tqradiobutton.h>
#include <tqlayout.h>
#include <kseparator.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#include <tqlabel.h>
#include <tqhbox.h>
#include <tqvbox.h>
#include <tqfont.h>

#include <kdebug.h>
#include <klocale.h>

KRecNewProperties::KRecNewProperties( TQWidget* p, const char* n )
  : TQDialog( p,n, 0, TQt::WType_Dialog|TQt::WStyle_Customize|TQt::WStyle_DialogBorder )
  , _filename( TQString() )
  , _samplerate( 44100 ), _channels( 2 ), _bits( 16 )
{
kdDebug( 60005 ) << k_funcinfo << endl;
	KConfig *config = KRecGlobal::kconfig();
	config->setGroup( "FileDefaults" );
	_samplerate = config->readNumEntry( "SamplingRate", 44100 );
	_channels = config->readNumEntry( "Channels", 2 );
	_bits = config->readNumEntry( "Bits", 16 );
	_usedefaults = config->readBoolEntry( "UseDefaults", false );

	_layout = new TQVBoxLayout( this, 5, 5 );

	TQLabel *captionlabel = new TQLabel( this );
	TQFont labelfont( captionlabel->font() );
	labelfont.setPointSize( labelfont.pointSize()*3/2 );
	captionlabel->setFont( labelfont );
	captionlabel->setText( i18n( "Properties for the new File" ) );
	captionlabel->tqsetAlignment( AlignCenter );
	_layout->addWidget( captionlabel );

	_filewidget = new KRecConfigFilesWidget( this );
	connect( _filewidget, TQT_SIGNAL( sRateChanged( int ) ), this, TQT_SLOT( ratechanged( int ) ) );
	connect( _filewidget, TQT_SIGNAL( sChannelsChanged( int ) ), this, TQT_SLOT( channelschanged( int ) ) );
	connect( _filewidget, TQT_SIGNAL( sBitsChanged( int ) ), this, TQT_SLOT( bitschanged( int ) ) );
	connect( _filewidget, TQT_SIGNAL( sUseDefaultsChanged( bool ) ), this, TQT_SLOT( usedefaultschanged( bool ) ) );

	TQWidget *_btnWidget = new TQWidget( this );
	_layoutbuttons = new TQHBoxLayout( _btnWidget );
	_layoutbuttons->addStretch( 100 );
	_btnok = new KPushButton( KStdGuiItem::ok(), _btnWidget );
	connect( _btnok, TQT_SIGNAL( clicked() ), this, TQT_SLOT( accept() ) );
	_layoutbuttons->addWidget( _btnok, 0 );

	_layout->addWidget( new KSeparator( KSeparator::HLine, this ) );
	_layout->addWidget( _filewidget );
	_layout->addWidget( new KSeparator( KSeparator::HLine, this ) );
	_layout->addWidget( _btnWidget );

	tqsetSizePolicy( TQSizePolicy::Maximum, TQSizePolicy::Maximum );
}
KRecNewProperties::~KRecNewProperties() {
kdDebug( 60005 ) << k_funcinfo << endl;
}

TQString KRecNewProperties::filename() { return _filename; }
int KRecNewProperties::samplerate() { return _samplerate; }
int KRecNewProperties::channels() { return _channels; }
int KRecNewProperties::bits() { return _bits; }
bool KRecNewProperties::usedefaults() { return _usedefaults; }

void KRecNewProperties::ratechanged( int rate ) { _samplerate = rate; }
void KRecNewProperties::channelschanged( int channels ) { _channels = channels; }
void KRecNewProperties::bitschanged( int bits ) { _bits = bits; }
void KRecNewProperties::usedefaultschanged( bool n ) {
	_usedefaults = n;
	KRecGlobal::kconfig()->setGroup( "FileDefaults" );
	KRecGlobal::kconfig()->writeEntry( "UseDefaults", _usedefaults );
}

void KRecNewProperties::done( int r ) {
kdDebug( 60005 ) << k_funcinfo << endl;
	TQDialog::done( r );
}

