#ifndef ViewSurround_h
#define ViewSurround_h

class TQBoxLayout;
class TQGridLayout;
class TQWidget;

class MixDevice;
class MixDeviceWidget;
class Mixer;
#include "viewbase.h"

class ViewSurround : public ViewBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    ViewSurround(TQWidget* parent, const char* name, const TQString & caption, Mixer* mixer, ViewBase::ViewFlags vflags);
    ~ViewSurround();

    virtual int count();
    virtual int advice();
    virtual void setMixSet(MixSet *mixset);
    virtual TQWidget* add(MixDevice *mdw);
    virtual void constructionFinished();

    TQSize tqsizeHint() const;

public slots:
    virtual void refreshVolumeLevels();

private:
    MixDeviceWidget* createMDW(MixDevice *md, bool small, Qt::Orientation orientation);
    MixDevice *_mdSurroundFront;
    MixDevice *_mdSurroundBack;

    TQBoxLayout* _layoutMDW;
    TQBoxLayout* _layoutSliders;
    TQGridLayout* _layoutSurround;
};

#endif

