//-*-C++-*-
/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2000 Stefan Schimanski <1Stein@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KSMALLSLIDER_H
#define KSMALLSLIDER_H

#include <kpanelapplet.h>

#include <tqwidget.h>
#include <tqpixmap.h>
#include <tqrangecontrol.h>

class KSmallSlider : public TQWidget, public TQRangeControl
{
      Q_OBJECT
  TQ_OBJECT

   public:
      KSmallSlider( TQWidget *parent, const char *name=0 );
      KSmallSlider( Qt::Orientation, TQWidget *parent, const char *name=0 );
      KSmallSlider( int minValue, int maxValue, int pageStep, int value,
		    Qt::Orientation, TQWidget *parent, const char *name=0 );

    //virtual void setTracking( bool enable );
    //bool tracking() const;
      TQSize tqsizeHint() const;
      TQSizePolicy sizePolicy() const;
      TQSize tqminimumSizeHint() const;

      int minValue() const;
      int maxValue() const;
      void setMinValue( int ); //  Don't use these unless you make versions
      void setMaxValue( int ); //  that work. -esigra
      int lineStep() const;
      int pageStep() const;
      void setLineStep( int );
      void setPageStep( int );
      int  value() const;

    //void paletteChange ( const TQPalette & oldPalette );
      bool gray() const;

public slots:
    virtual void setValue( int );
    void addStep();
    void subtractStep();

      void setGray( bool value );
      void setColors( TQColor high, TQColor low, TQColor back );
      void setGrayColors( TQColor high, TQColor low, TQColor back );

      signals:
      void valueChanged( int value );
      void sliderPressed();
      void sliderMoved( int value );
      void sliderReleased();

   protected:
      void resizeEvent( TQResizeEvent * );
      void paintEvent( TQPaintEvent * );

      void mousePressEvent( TQMouseEvent * );
      void mouseReleaseEvent( TQMouseEvent * );
      void mouseMoveEvent( TQMouseEvent * );
      void wheelEvent( TQWheelEvent * );

      void valueChange();
      void rangeChange();

   private:
    //enum State { Idle, Dragging };

      void init();
      int positionFromValue( int ) const;
      int valueFromPosition( int ) const;
      void moveSlider( int );
    //void resetState();

    //      int slideLength() const;
      int available() const;
      int goodPart( const TQPoint& ) const;
    //void initTicks();

    //TQCOORD sliderPos;
    //int sliderVal;
    //State state;
    //bool track;
      bool grayed;
      Qt::Orientation _orientation;
      TQColor colHigh, colLow, colBack;
      TQColor grayHigh, grayLow, grayBack;

};

/*
inline bool KSmallSlider::tracking() const
{
    return track;
}
*/
#endif
