/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 1996-2004 Christian Esken <esken@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqptrlist.h>

#include <kdebug.h>
#include <kdialogbase.h>
#include <klocale.h>

#include "dialogviewconfiguration.h"
#include "mixdevicewidget.h"
#include "mixdevice.h"


DialogViewConfiguration::DialogViewConfiguration( TQWidget*, ViewBase& view)
    : KDialogBase(  Plain, i18n( "Configure" ), Ok|Cancel, Ok ),
      _view(view)
{
    TQPtrList<TQWidget> &mdws = view._mdws;
    _layout = new TQVBoxLayout(plainPage(),0,-1, "_layout" );

    //    kdDebug(67100) << "DialogViewConfiguration::DialogViewConfiguration add header" << "\n";
    TQLabel* qlb = new TQLabel( i18n("Configure"), plainPage() );
    //TQLabel* qlb = new TQLabel( i18n("Show"), plainPage() );
    _layout->addWidget(qlb);

    for ( TQWidget *qw = mdws.first(); qw != 0; qw = mdws.next())
    {
	if ( qw->inherits("MixDeviceWidget") ) {
	    MixDeviceWidget *mdw = static_cast<MixDeviceWidget*>(qw);
	    TQString mdName = mdw->mixDevice()->name();
            mdName.replace('&', "&&"); // Quoting the '&' needed, to prevent TQCheckBox creating an accelerator
	    TQCheckBox* cb = new TQCheckBox( mdName, plainPage() );
	    _qEnabledCB.append(cb);
	    cb->setChecked( !mdw->isDisabled() ); //mdw->isVisible() );
	    _layout->addWidget(cb);
	}
    }
    _layout->activate();
    resize(_layout->tqsizeHint() );
    connect( this, TQT_SIGNAL(okClicked())   , this, TQT_SLOT(apply()) );
}

DialogViewConfiguration::~DialogViewConfiguration()
{
}

void DialogViewConfiguration::apply()
{
    TQPtrList<TQWidget> &mdws = _view._mdws;

    // --- 2-Step Apply ---

    // --- Step 1: Show and Hide Widgets ---
    TQCheckBox *cb = _qEnabledCB.first();
    for ( TQWidget *qw = mdws.first(); qw != 0; qw = mdws.next())
    {
	if ( qw->inherits("MixDeviceWidget") ) {
	    MixDeviceWidget *mdw = static_cast<MixDeviceWidget*>(qw);
	    if ( cb->isChecked() ) {
		mdw->setDisabled(false);
	    }
	    else {
		mdw->setDisabled(true);
	    }
	
	    cb = _qEnabledCB.next();
	}
    }
    
    // --- Step 2: Tell the view, that it has changed (probably it needs some "polishing" ---
    _view.configurationUpdate();
}

TQSize DialogViewConfiguration::tqsizeHint() const {
    //    kdDebug(67100) << "DialogViewConfiguration::tqsizeHint() is (100,500)\n";
    return _layout->tqsizeHint();
}

#include "dialogviewconfiguration.moc"

