/***************************************************************************
    begin                : Wed Feb 6 2002
    copyright            : (C) 2002 - 2004 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SLIDERACTION_H
#define SLIDERACTION_H

#include <kaction.h>
#include <tqslider.h>

class TQBoxLayout;
class TQDockWindow;

class VolumeSlider : public TQSlider
{
    Q_OBJECT
  TQ_OBJECT

public:
    VolumeSlider(Qt::Orientation o, TQWidget *parent, const char *name);

    int volume() const;
    void setVolume(int value);

    void setOrientation(Qt::Orientation o);

signals:
    void signalVolumeChanged(int value);

protected:
    virtual void wheelEvent(TQWheelEvent *e);
    virtual void focusInEvent(TQFocusEvent *);

private slots:
    void slotValueChanged(int value);
};

class SliderAction : public KAction
{
    Q_OBJECT
  TQ_OBJECT

public:
    SliderAction(const TQString &text, TQObject *parent, const char *name);
    virtual ~SliderAction();

    VolumeSlider *volumeSlider() const { return m_volumeSlider; }
    TQSlider *trackPositionSlider() const { return m_trackPositionSlider; }

    bool dragging() const { return m_dragging; }
    bool volumeDragging() const { return m_volumeDragging; }

    virtual int plug(TQWidget *parent, int index = -1);
    virtual void unplug(TQWidget *widget);

    static const int minPosition;
    static const int maxPosition;

public slots:
    void slotUpdateOrientation();

signals:
    void signalPositionChanged(int position);
    void signalVolumeChanged(int volume);

private:
    TQWidget *createWidget(TQWidget *parent);

private slots:
    void slotUpdateSize();
    void slotVolumeSliderPressed();
    void slotVolumeSliderReleased();
    void slotSliderPressed();
    void slotSliderReleased();
    void slotToolbarDestroyed();

private:
    KToolBar *m_toolBar;
    TQBoxLayout *m_layout;
    TQSlider *m_trackPositionSlider;
    VolumeSlider *m_volumeSlider;
    bool m_dragging;
    bool m_volumeDragging;

    static const int volumeMax = 50;
};

#endif
