/*

    Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#include "midiportdlg.h"
#include <klocale.h>

#include <kapplication.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <kseparator.h>
#include <kbuttonbox.h>
#include <tqlineedit.h>
#include <tqbutton.h>
#include <tqpushbutton.h>
#include <kstdguiitem.h>

MidiPortDlg::MidiPortDlg(TQWidget *parent, const char *oldname, const char *title) :TQDialog(parent,title,TRUE)
{
	TQVBoxLayout *maintqlayout = new TQVBoxLayout(this);

// caption label: title

	maintqlayout->addSpacing(5);
	TQLabel *captionlabel = new TQLabel(this);
	TQFont labelfont(captionlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	captionlabel->setFont(labelfont);
	captionlabel->setText(i18n("OSS MIDI Port"));
	captionlabel->tqsetAlignment(AlignCenter);
	//min_size(captionlabel);
	maintqlayout->addWidget(captionlabel);

// hruler

	maintqlayout->addSpacing(5);
	KSeparator *ruler2 = new KSeparator( KSeparator::HLine, this);
	maintqlayout->addWidget(ruler2);
	maintqlayout->addSpacing(5);

// editwidget

	edit = new TQLineEdit(this);
	edit->setText(oldname);
	//min_size(edit);

	maintqlayout->addWidget(edit);

// hruler

	maintqlayout->addSpacing(5);
	KSeparator *ruler = new KSeparator( KSeparator::HLine, this);
	maintqlayout->addWidget(ruler);
	maintqlayout->addSpacing(5);

// buttons

	TQHBoxLayout *buttontqlayout = new TQHBoxLayout;
	maintqlayout->addSpacing(5);
	maintqlayout->addLayout(buttontqlayout);
	maintqlayout->addSpacing(5);

	buttontqlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	TQPushButton *helpbutton = bbox->addButton(KStdGuiItem::help(), TQT_TQOBJECT(this), TQT_SLOT( help() ));
	bbox->addStretch(1);
	helpbutton->setAutoDefault( true );
	helpbutton->setDefault( true );

	TQPushButton *okbutton = bbox->addButton(KStdGuiItem::ok());
	connect( okbutton, TQT_SIGNAL( clicked() ), TQT_SLOT(accept() ) );
	okbutton->setAutoDefault( true );
	okbutton->setDefault( true );

	bbox->tqlayout();

	buttontqlayout->addWidget(bbox);
	buttontqlayout->addSpacing(5);

	maintqlayout->freeze();
}

const char *MidiPortDlg::device()
{
	return edit->text().ascii();
}

void MidiPortDlg::help()
{
	KApplication::kApplication()->invokeHelp("", "artsbuilder");
}

#include "midiportdlg.moc"
