	/*

	Copyright (C) 1998-2001 Stefan Westerfeld
                            stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#include "interfacedlg.h"
#include "structureport.h"
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlistbox.h>
#include <kbuttonbox.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <kseparator.h>
#include <klocale.h>
#include <tqlineedit.h>
#include <stdio.h>
#include <arts/debug.h>
#include <arts/core.h>
#include <arts/dispatcher.h>
#include <tqpushbutton.h>
#include <kstdguiitem.h>

using namespace std;

InterfaceDlg::InterfaceDlg(TQWidget *parent) :TQDialog(parent,"Props", TRUE)
{
	setCaption(i18n("aRts: Structureport View"));

	TQVBoxLayout *maintqlayout = new TQVBoxLayout(this);
	//TQHBoxLayout *contentstqlayout = new TQHBoxLayout;

// object type
/*
	maintqlayout->addSpacing(5);
	TQLabel *objectlabel = new TQLabel(this);
	TQFont labelfont(objectlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	objectlabel->setFont(labelfont);
	objectlabel->setText(TQString(" ")+i18n("Object type: ")+TQString(port->owner->name())+TQString(" "));
	objectlabel->tqsetAlignment(AlignCenter);
	min_size(objectlabel);
	maintqlayout->addWidget(objectlabel);
*/

// port description

/*
	maintqlayout->addSpacing(5);
	TQLabel *portlabel = new TQLabel(this);
	labelfont.setPointSize(labelfont.pointSize()*4/5);
	portlabel->setFont(labelfont);
	portlabel->setText(i18n("Port description: ")+ port->description);
	min_size(portlabel);
	portlabel->tqsetAlignment(AlignCenter);
	maintqlayout->addWidget(portlabel);

	int labelwidth = imax(portlabel->tqsizeHint().width(),objectlabel->tqsizeHint().width());

	portlabel->setMinimumWidth(labelwidth);
	objectlabel->setMinimumWidth(labelwidth);

// hruler

	maintqlayout->addSpacing(5);
	KSeparator *ruler = new KSeparator( KSeparator::HLine, this);
	maintqlayout->addWidget(ruler);
	maintqlayout->addSpacing(5);
	maintqlayout->addLayout(contentstqlayout);
*/
// list

	listbox = new TQListBox(this);

	update();

	listbox->setMinimumSize(340,400);
	maintqlayout->addWidget(listbox);
        connect( listbox, TQT_SIGNAL( doubleClicked ( TQListBoxItem *)), this,
                 TQT_SLOT(accept()));
// hruler

	maintqlayout->addSpacing(5);
	KSeparator *ruler2 = new KSeparator( KSeparator::HLine, this);
	maintqlayout->addWidget(ruler2);

// buttons

	TQHBoxLayout *buttontqlayout = new TQHBoxLayout;
	maintqlayout->addSpacing(5);
	maintqlayout->addLayout(buttontqlayout);
	maintqlayout->addSpacing(5);

	buttontqlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	bbox->addButton(KStdGuiItem::help(), TQT_TQOBJECT(this), TQT_SLOT( help() ));
	bbox->addStretch(1);

	TQButton *okbutton = bbox->addButton(KStdGuiItem::ok());
	connect( okbutton, TQT_SIGNAL( clicked() ), TQT_SLOT(accept() ) );

	TQButton *cancelbutton = bbox->addButton(KStdGuiItem::cancel());
	connect( cancelbutton, TQT_SIGNAL( clicked() ), TQT_SLOT(reject() ) );

	bbox->tqlayout();
	//min_size(bbox);

	buttontqlayout->addWidget(bbox);
	buttontqlayout->addSpacing(5);

	//maintqlayout->activate();
	maintqlayout->freeze();
}

string InterfaceDlg::interfaceName()
{
	if(listbox->currentItem() != -1)
	{
		string s = listbox->text(listbox->currentItem()).local8Bit().data();
		string::iterator j = s.begin();
		while(*j == ' ') j++;
			return string(j, s.end());
	}
	return "";
}

void InterfaceDlg::raise()
{
}

void InterfaceDlg::lower()
{
}

void InterfaceDlg::rename()
{
}

void InterfaceDlg::update(const string& interface, const string& indent)
{
	listbox->insertItem((indent + interface).c_str());

	vector<string> *tqchildren = Arts::Dispatcher::the()->interfaceRepo().queryChildren(interface);
	for (vector<string>::iterator ci = tqchildren->begin(); ci != tqchildren->end(); ++ci)
		update(ci->c_str(), indent+"  ");
	delete tqchildren;
}

void InterfaceDlg::update()
{
	update("Arts::Object", "");
}

void InterfaceDlg::help()
{
	KApplication::kApplication()->invokeHelp("", "karts");
}

#include "interfacedlg.moc"
