	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#include <tqfile.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqlineedit.h>

#include <kbuttonbox.h>
#include <kfiledialog.h>
#include <kseparator.h>
#include <klocale.h>
#include <kapplication.h>
#include <kstdguiitem.h>

#include <unistd.h>
#include "execdlg.h"
#include "dirmanager.h"
#include <arts/debug.h>
#include <tqpushbutton.h>

#ifndef KDE_USE_FINAL
static void min_size(TQWidget *w) {
  w->setMinimumSize(w->tqsizeHint());
}
#endif

ExecDlg::ExecDlg(TQWidget *parent, ExecutableStructure *structure)
		:TQDialog(parent,"X")
/*, TRUE)*/
{
	this->structure = structure;

	setCaption(i18n("aRts Module Execution"));

	maintqlayout = new TQVBoxLayout(this);

// caption label: "Synthesis running..."

	maintqlayout->addSpacing(5);
	TQLabel *captionlabel = new TQLabel(this);
	TQFont labelfont(captionlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	captionlabel->setFont(labelfont);
	captionlabel->setText(TQString(" ")+i18n("Synthesis running...")+TQString(" "));
	captionlabel->tqsetAlignment(AlignCenter);
	min_size(captionlabel);
	maintqlayout->addWidget(captionlabel);

	cpuusagelabel = new TQLabel(this);
	cpuusagelabel->setText(i18n("CPU usage: unknown"));

    cpuusagetimer = new TQTimer( this );
	connect( cpuusagetimer, TQT_SIGNAL(timeout()),
		this, TQT_SLOT(updateCpuUsage()) );
	connect( cpuusagetimer, TQT_SIGNAL(timeout()),
		this, TQT_SLOT(guiServerTick()) );
	cpuusagetimer->start( 2000, false );

	min_size(cpuusagelabel);
	maintqlayout->addWidget(cpuusagelabel);

//	ruler above the slidertqlayout

	maintqlayout->addSpacing(5);
        KSeparator* sep = new KSeparator( KSeparator::HLine, this);
	maintqlayout->addWidget(sep);
	maintqlayout->addSpacing(5);

//	sliders, controlpanels

	slidertqlayout = new TQVBoxLayout;
	maintqlayout->addLayout(slidertqlayout);

#if 0 /* PORT */
	this->GUIServer = GUIServer;
	GUIServer->setGlobalParent(this);
	GUIServer->setGlobalLayout(slidertqlayout);
#endif

//  hruler below the slidertqlayout

	maintqlayout->addSpacing(5);
        sep = new KSeparator( KSeparator::HLine, this);
	maintqlayout->addWidget(sep);
	maintqlayout->addSpacing(5);

// buttons

	TQHBoxLayout *buttontqlayout = new TQHBoxLayout;
	maintqlayout->addSpacing(5);
	maintqlayout->addLayout(buttontqlayout);
	maintqlayout->addSpacing(5);

	buttontqlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	bbox->addButton(KStdGuiItem::help(), TQT_TQOBJECT(this), TQT_SLOT( help() ));

	bbox->addStretch(1);

	TQButton *savebutton = bbox->addButton(KStdGuiItem::saveAs());
	connect( savebutton, TQT_SIGNAL( clicked() ), TQT_SLOT(saveSession() ) );

	TQButton *okbutton = bbox->addButton(KStdGuiItem::ok());
	connect( okbutton, TQT_SIGNAL( clicked() ), TQT_SLOT(accept() ) );

	bbox->tqlayout();
	//min_size(bbox);

	buttontqlayout->addWidget(bbox);
	buttontqlayout->addSpacing(5);

//	maintqlayout->freeze();
}

void ExecDlg::start()
{
	maintqlayout->freeze();
}

void ExecDlg::guiServerTick()
{
#if 0 /* TODO:PORT */
	GUIServer->tick();
#endif
}

void ExecDlg::updateCpuUsage()
{
#if 0 /* TODO:PORT */
	char cpuusage[100];

	ArtsCorba::tqStatus s = Synthesizer->gettqStatus();
	if(s.halted)
	{
		cpuusagetimer->stop();
		accept();
		PortableKDE::KMsgSorry(this,i18n("Your synthesis has been interrupted due to excessive CPU load."));
		/*
		KMsgBox::message(this,i18n("Error"),
		  i18n("Your synthesis has been interrupted due to excessive CPU load."),
		  KMsgBox::STOP);
		*/
		// warning: this is invalid after accept();
		return;
	}
	sprintf(cpuusage,"%s%3.2f%%",
		(const char *)i18n("CPU usage: "),s.cpu_usage*100);

	cpuusagelabel->setText(cpuusage);

	if(!structure->isExecuting()) accept();
	// warning: this is invalid after accept();
#endif
}

void ExecDlg::done( int r )
{
	structure->stopExecute();
	TQDialog::done(r);
	emit ready();
}

void ExecDlg::saveSession()
{
	chdir(DirManager::sessionDir());

	TQString filename = KFileDialog::getSaveFileName(0,"*.arts-session",this);
	if(!filename.isEmpty())
	{
		arts_debug("save... %s",filename.local8Bit().data());
		structure->saveSession(TQFile::encodeName(filename));
	}
}

void ExecDlg::help()
{
	KApplication::kApplication()->invokeHelp("", "karts");
}
#include "execdlg.moc"
