/***************************************************************************
                             toolbartabwidget.cpp
                             ---------------------
    copyright            : (C) 2003 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

//qt includes
#include <tqevent.h>
#include <tqlayout.h>
#include <tqobjectlist.h>
#include <tqpoint.h>
#include <tqtabbar.h>
#include <tqwidgetstack.h>
#include <tqtabwidget.h>
#include <tqfontmetrics.h>

//kde includes
#include <kaction.h>
#include <kaccelmanager.h>
#include <kdeversion.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <ktoolbar.h>
#include <ktoolbarbutton.h>
#include <kdebug.h>
#include <kglobalsettings.h>

//app includes
#include "toolbartabwidget.h"

ToolbarTabWidget::ToolbarTabWidget(TQWidget * parent, const char * name, WFlags f)
:TQTabWidget(parent, name, f)
{
  m_popupMenu = new KPopupMenu(this);
  m_popupMenu->insertTitle(i18n("Toolbar Menu"), 1);
  m_popupMenu->insertItem(i18n("New Action..."), parent, TQT_SLOT(slotNewAction()));
  m_popupMenu->insertSeparator();
  m_popupMenu->insertItem(i18n("New Toolbar..."), parent, TQT_SLOT(slotAddToolbar()));
  m_popupMenu->insertItem(i18n("Remove Toolbar"), this, TQT_SLOT(slotRemoveToolbar()));
  m_popupMenu->insertItem(i18n("Rename Toolbar..."), this, TQT_SLOT(slotRenameToolbar()));
  m_popupMenu->insertItem(SmallIconSet("configure_toolbars"), i18n("Configure Toolbars..."), this, TQT_SLOT(slotEditToolbar()));

  connect(this, TQT_SIGNAL(removeToolbar(const TQString&)),
          parent, TQT_SLOT(slotRemoveToolbar(const TQString&)));
  connect(this, TQT_SIGNAL(renameToolbar(const TQString&)),
          parent, TQT_SLOT(slotRenameToolbar(const TQString&)));
  connect(this, TQT_SIGNAL(editToolbar(const TQString&)),
          parent, TQT_SLOT(slotConfigureToolbars(const TQString&)));
  connect(this, TQT_SIGNAL(newAction()),
          parent, TQT_SLOT(slotNewAction()));
  connect(this, TQT_SIGNAL(addToolbar()),
          parent, TQT_SLOT(slotAddToolbar()));
  KAcceleratorManager::setNoAccel(this);
}

void ToolbarTabWidget::insertTab(TQWidget *child, const TQString &label, const TQString &id)
{
  if (child->inherits("KToolBar") && child->parentWidget())
  {
    TQTabWidget::insertTab(child->parentWidget(), label);
    toolbarList.insert(id, child);
  }
}

TQWidget* ToolbarTabWidget::page(int index)
{
  TQWidget *w = TQTabWidget::page(index);

  for (TQMap<TQString, TQWidget*>::Iterator it = toolbarList.begin(); it != toolbarList.end(); ++it)
  {
    if (it.data()->parentWidget() == w)
    {
      w = *it;
      break;
    }
  }
  return w;
}

TQString ToolbarTabWidget::id(TQWidget *w) const
{
  TQString idStr;
  for (TQMap<TQString, TQWidget*>::ConstIterator it = toolbarList.constBegin(); it != toolbarList.constEnd(); ++it)
  {
    if (it.data()->parentWidget() == w)
    {
      idStr = it.key();
      break;
    }
  }
  return idStr;
}

TQString ToolbarTabWidget::id(int index) const
{
  TQWidget *w = TQTabWidget::page(index);
  TQString idStr;
  for (TQMap<TQString, TQWidget*>::ConstIterator it = toolbarList.constBegin(); it != toolbarList.constEnd(); ++it)
  {
    if (it.data()->parentWidget() == w)
    {
      idStr = it.key();
      break;
    }
  }
  return idStr;
}

TQWidget* ToolbarTabWidget::page(const TQString& id)
{
  TQWidget *w = toolbarList.find(id).data();
  return w;
}

void ToolbarTabWidget::removePage(TQWidget * w)
{
  TQWidget *parent = w->parentWidget();
  if (w->inherits("KToolBar") && parent)
  {
    TQTabWidget::removePage(parent);
    for (TQMap<TQString, TQWidget*>::ConstIterator it = toolbarList.constBegin(); it != toolbarList.constEnd(); ++it)
    {
      if (it.data() == w)
      {
        toolbarList.remove(it.key());
        break;
      }
    }
    delete parent;
  }
}

void ToolbarTabWidget::slotRemoveToolbar()
{
  emit removeToolbar(tabUnderMouse.lower());
}

void ToolbarTabWidget::slotRenameToolbar()
{
  emit renameToolbar(tabUnderMouse.lower());
}

void ToolbarTabWidget::slotEditToolbar()
{
  emit editToolbar(tabUnderMouseLabel + " <quanta>");
}

void ToolbarTabWidget::mousePressEvent ( TQMouseEvent * e )
{
  if (e->button() == Qt::RightButton)
  {
    TQPoint p = e->globalPos();
    TQTab *tab = 0L;
    TQWidget *pageW = 0L;
    for (int i =0; i < tabBar()->count(); i++)
    {
      tab = tabBar()->tabAt(i);
      pageW = page(i);
      TQRect r = tab->rect();
      TQPoint p1 = mapToGlobal(r.topLeft());
      TQPoint p2 = mapToGlobal(r.bottomRight());
      if (TQRect(p1, p2).contains(p))
          break;
      else
        tab = 0L;
    }
    tabUnderMouseLabel = tab ? tab->text() : label(currentPageIndex());
    if (!pageW)
      pageW = currentPage();
    for (TQMap<TQString, TQWidget*>::Iterator it = toolbarList.begin(); it != toolbarList.end(); ++it)
    {
      if (it.data()->parentWidget() == pageW)
      {
        tabUnderMouse = it.key();
        break;
      }
    }
    m_popupMenu->changeTitle(1, i18n("Toolbar Menu") + " - " + i18n(tabUnderMouseLabel.utf8()));
    m_popupMenu->popup(p);
  }
}


void ToolbarTabWidget::resizeEvent(TQResizeEvent *e)
{
  TQWidget::resizeEvent(e);
  TQWidget *tb;
  for (TQMap<TQString, TQWidget*>::Iterator it = toolbarList.begin(); it != toolbarList.end(); ++it)
  {
    tb = it.data();
    tb->resize(TQSize(width(), tb->height()));
  }
  int i = currentPageIndex();
  if (i > 0)
  {
    setCurrentPage(i -1);
  } else
  if (i+1 < count())
  {
    setCurrentPage(i + 1);
  }
  setCurrentPage(i);
}

int ToolbarTabWidget::tabHeight() const
{
  int height = tabBar()->height();
  if (height < 2)
  {
      height = TQFontMetrics(KGlobalSettings::generalFont()).height() + 12;
  }
  return height;
}


QuantaToolBar::QuantaToolBar(TQWidget *parent, const char *name, bool honor_style, bool readConfig)
:KToolBar (parent, name=0, honor_style, readConfig)
{
  m_popupMenu = new KPopupMenu(this);
  m_toolbarTab = dynamic_cast<ToolbarTabWidget*>(parent->parentWidget());
  currentActionName = "";
  m_iconTextMenu = new KPopupMenu(this);
  m_iconTextMenu->setCheckable(true);
  m_iconTextMenu->insertItem(i18n("Icons Only"), 0);
  m_iconTextMenu->insertItem(i18n("Text Only"), 1);
  m_iconTextMenu->insertItem(i18n("Text Alongside Icons"), 2);
  m_iconTextMenu->insertItem(i18n("Text Under Icons"), 3);
  connect(m_iconTextMenu, TQT_SIGNAL(activated(int)), TQT_SLOT(slotIconTextChanged(int)));
  connect(m_iconTextMenu, TQT_SIGNAL(aboutToShow()), TQT_SLOT(slotIconTextMenuAboutToShow()));
  setIconText(ToolbarTabWidget::ref()->iconText(), false);
}

void QuantaToolBar::slotIconTextMenuAboutToShow()
{
  m_iconTextMenu->setItemChecked(0, false);
  m_iconTextMenu->setItemChecked(1, false);
  m_iconTextMenu->setItemChecked(2, false);
  m_iconTextMenu->setItemChecked(3, false);
  switch (ToolbarTabWidget::ref()->iconText()) 
  {
    case IconOnly: m_iconTextMenu->setItemChecked(0, true);
                   break;
    case TextOnly: m_iconTextMenu->setItemChecked(1, true);
                   break;
    case IconTextRight: m_iconTextMenu->setItemChecked(2, true);
                   break;
    case IconTextBottom: m_iconTextMenu->setItemChecked(3, true);
                   break;
  }  
}

void QuantaToolBar::slotIconTextChanged(int id)
{
  ToolbarTabWidget *toolbarTab = ToolbarTabWidget::ref();
  int width = toolbarTab->width();
  int bigHeight = iconSize() + TQFontMetrics(KGlobalSettings::toolBarFont()).height() + 10;
  int normalHeight = iconSize() + 10;
  for (int i = 0; i < toolbarTab->count(); i++)
  {
    QuantaToolBar *tb = static_cast<QuantaToolBar*>(toolbarTab->page(i));
    switch (id)
    {
      case 0: tb->setIconText(IconOnly); 
              tb->setGeometry(0,0, width, normalHeight);
              break;
      case 1: tb->setIconText(TextOnly); 
              tb->setGeometry(0,0, width, normalHeight);
              break;
      case 2: tb->setIconText(IconTextRight); 
              tb->setGeometry(0,0, width, normalHeight);
              break;
      case 3: tb->setIconText(IconTextBottom); 
              tb->setGeometry(0,0, width, bigHeight);
              break;
    }    
  }
  toolbarTab->setIconText(iconText()); 
  if (id == 3)
  {
    toolbarTab->setFixedHeight(toolbarTab->tabHeight() + height() + 3);
  } else
  {
    toolbarTab->setFixedHeight(toolbarTab->tabHeight() + height() + 3);
  }
}

void QuantaToolBar::mousePressEvent(TQMouseEvent *e)
{
  if (e->button() == Qt::RightButton)
  {
    m_popupMenu->clear();
    TQPoint p = e->globalPos();
    if (m_toolbarTab)
    {
      m_toolbarTab->tabUnderMouse = m_toolbarTab->id(m_toolbarTab->currentPageIndex());
      m_toolbarTab->tabUnderMouseLabel = m_toolbarTab->label(m_toolbarTab->currentPageIndex());
      m_popupMenu->insertTitle(i18n("Toolbar Menu") + " - "
                               + i18n(m_toolbarTab->tabUnderMouseLabel.utf8()));
      m_popupMenu->insertItem(i18n("New Action..."), m_toolbarTab, TQT_SIGNAL(newAction()));
      TQObjectList* tqchildrenList = queryList("KToolBarButton");
      for (uint i = 0; i < tqchildrenList->count(); i++)
      {
        KToolBarButton *w = static_cast<KToolBarButton*>(TQT_TQWIDGET(tqchildrenList->at(i)));
        TQPoint p1 = w->parentWidget()->mapToGlobal(w->pos());
        TQPoint p2 = TQPoint(p1.x() + w->width(), p1.y()+w->height());
        if (TQRect(p1, p2).contains(p))
        {
          currentActionName = w->textLabel();
          TQString actionName = currentActionName;
          m_popupMenu->insertItem(i18n("Remove Action - %1").tqarg(actionName.replace('&',"&&")), this, TQT_SLOT(slotRemoveAction()));
          m_popupMenu->insertItem(i18n("Edit Action - %1").tqarg(actionName), this, TQT_SLOT(slotEditAction()));
          break;
        }
      }
      m_popupMenu->insertSeparator();
      m_popupMenu->insertItem(i18n("New Toolbar..."), m_toolbarTab, TQT_SIGNAL(addToolbar()));
      m_popupMenu->insertItem(i18n("Remove Toolbar"), m_toolbarTab, TQT_SLOT(slotRemoveToolbar()));
      m_popupMenu->insertItem(i18n("Rename Toolbar..."), m_toolbarTab, TQT_SLOT(slotRenameToolbar()));
      m_popupMenu->insertSeparator();
      m_popupMenu->insertItem( i18n("Text Position"), m_iconTextMenu);
      m_popupMenu->insertItem(SmallIconSet("configure_toolbars"), i18n("Configure Toolbars..."), m_toolbarTab, TQT_SLOT(slotEditToolbar()));
    }
    m_popupMenu->popup(p);
  }
}

void QuantaToolBar::slotEditAction()
{
  emit editAction(currentActionName);
}

void QuantaToolBar::slotRemoveAction()
{
    if ( KMessageBox::warningContinueCancel(this, i18n("<qt>Are you sure you want to remove the <b>%1</b> action?</qt>").tqarg(currentActionName),TQString(),KStdGuiItem::del()) == KMessageBox::Continue )
  {
    emit removeAction(m_toolbarTab->tabUnderMouse, currentActionName);
  }
}


#include "toolbartabwidget.moc"
