/***************************************************************************
                          uploadtreeview.h  -  description
                             -------------------
    begin                : Sun Aug 25 2002
    copyright            : (C) 2002, 2003 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef UPLOADTREEVIEW_H
#define UPLOADTREEVIEW_H

#include <tqdir.h>
#include <tqpixmap.h>
#include <tqheader.h>

#include "uploadtreefolder.h"
#include "uploadtreefile.h"

class KFileItem;

/**
  *@author George Vilches & Andras Mantia
  */

class UploadTreeView : public KListView {
  Q_OBJECT
  TQ_OBJECT
public:
  UploadTreeView( TQWidget *parent, const char *name=0L );
  ~UploadTreeView();
  UploadTreeFile* addItem( const KURL &a_url, const KFileItem &a_fileItem);
  TQListViewItem* findItem( const TQString& );
  int checkboxTree( TQListViewItem *it = 0);
  void expandAll( TQListViewItem * = 0 );
  void collapseAll( TQListViewItem * = 0 );
  void invertAll( TQListViewItem * = 0 );
  virtual void selectAll( bool select);
  /** No descriptions */
  TQListViewItem* itemByUrl(const KURL& a_url);

public slots:
  void slotSelectFile( TQListViewItem * );
  void slotSelectFile( );
  void selectAllUnderNode( TQListViewItem *it, bool select );

private slots:
  void slotDoubleClicked(TQListViewItem *, const TQPoint &, int );

private:
  UploadTreeFolder* findFolder( UploadTreeFolder *, const TQString&);
  UploadTreeFolder* printTree( UploadTreeFolder *, const TQString&);
};

#endif
