/***************************************************************************
                          tableitem.cpp -  description
                             -------------------
    begin                : Mon 15 Mar 2004
    copyright            : (C) 2004 by Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqtextedit.h>
#include <tqpainter.h>
#include "tableitem.h"

TableItem::TableItem(TQTable* table, EditType et) : TQTableItem(table, et)
{
  setReplaceable(false);
  m_halign = TQt::AlignLeft;
  m_valign = TQt::AlignVCenter;
}

TableItem::TableItem(TQTable* table, EditType et, const TQString& text) : TQTableItem(table, et, text)
{
  setReplaceable(false);
  m_halign = TQt::AlignLeft;
  m_valign = TQt::AlignVCenter;
}

TableItem::TableItem (TQTable* table, EditType et, const TQString& text, const TQPixmap& p) :
  TQTableItem(table, et, text, p)
{
  setReplaceable(false);
  m_halign = TQt::AlignLeft;
  m_valign = TQt::AlignVCenter;
}

TQWidget* TableItem::createEditor() const
{
  TQTextEdit* Editor = new TQTextEdit(table()->viewport());
  Editor->setTextFormat(TQTextEdit::PlainText);
  Editor->setHScrollBarMode(TQScrollView::AlwaysOff);
  Editor->setVScrollBarMode(TQScrollView::AlwaysOff);
  Editor->setBold(m_header);
  Editor->setText(text());
  TQObject::connect(Editor, TQT_SIGNAL(textChanged()), table(), TQT_SLOT(doValueChanged()));
  return Editor;
}

void TableItem::setContentFromEditor(TQWidget *w)
{
  if (w->inherits( TQTEXTEDIT_OBJECT_NAME_STRING ))
    setText(((TQTextEdit*)w)->text());
  else
    TQTableItem::setContentFromEditor(w);
}

void TableItem::paint(TQPainter* p, const TQColorGroup& cg, const TQRect& cr, bool selected)
{
   if (m_header) {
     TQFont editFont = p->font();
     editFont.setBold(true);
     p->setFont(editFont);
   }
   TQRect cr0(0, 0, cr.width(), cr.height());
   if (selected) {
     p->fillRect(cr0, cg.brush(TQColorGroup::Highlight));
     p->setPen(cg.highlightedText());
   }
   else {
     p->fillRect(cr0, cg.brush(TQColorGroup::Base));
     p->setPen(cg.text());
   }
   if (!pixmap().isNull()) {
     p->drawPixmap(4, 4, pixmap());
     p->drawText(6 + pixmap().width(), 4, cr0.width()-8, cr0.height()-8, m_halign | m_valign | WordBreak, text());
   }
   else
     p->drawText(4, 4, cr0.width()-8, cr0.height()-8, m_halign | m_valign | WordBreak, text());
}

TQSize TableItem::tqsizeHint() const
{
   TQSize size = TQTableItem::tqsizeHint();
   size.setWidth(size.width()+8);
   size.setHeight(size.height()+8);
   return size;
}

