/***************************************************************************
                          framewizard.cpp  -  description
                             -------------------
    begin                : mer giu  4 14:14:07 CEST 2003
    copyright            : (C) |YEAR| by Gu2003Luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "framewizard.h"
#include "fmrceditor.h"
#include "fmfpeditor.h"
#include <kmessagebox.h>
//#include <kdebug.h>
#include <klocale.h>
#include <tqpushbutton.h>

#include "fwglobal.h"

static const TQString info1=i18n("You must select an area."),
                     info2=i18n("Before editing a frame you must save the file.");

FrameWizard::FrameWizard(TQWidget *parent, const char *name) : FrameWizardS(parent, name),
m_hasSelected(false),m_saved(false)
{
  m_hasSelected = false;
  m_currSA=vfe->internalTree()->root()->label();
  connect(this, TQT_SIGNAL(launchDraw()), this, TQT_SLOT(draw()));
  connect(vfe, TQT_SIGNAL(areaSelected(const TQString &)), this, TQT_SLOT(catchSelectedArea(const TQString &)));

  connect(pbHorizontal, TQT_SIGNAL(clicked()), this, TQT_SLOT(split()));
  connect(pbVertical, TQT_SIGNAL(clicked()), this, TQT_SLOT(split()));
  connect(pbEditFrame, TQT_SIGNAL(clicked()), this, TQT_SLOT(showFrameEditorDlg()));
  connect(pbReset, TQT_SIGNAL(clicked()), this, TQT_SLOT(reset()));
  connect(pbDelete, TQT_SIGNAL(clicked()), this, TQT_SLOT(remove()));
}

FrameWizard::~FrameWizard(){
#define TQT_CHECK_NULL
Q_CHECK_PTR( vfe );
}

void FrameWizard::catchSelectedArea(const TQString &id ){
  m_currSA = id; //is the current SelectableArea selected
  m_hasSelected = true;// a SelectableArea has been selected
}

void FrameWizard::split(){
  if(m_hasSelected) {
    int split = 0;
    TQString currNodeLabel = m_currSA;
    TQString senderName=TQT_TQOBJECT(const_cast<TQT_BASE_OBJECT_NAME*>(sender()))->name();
    if(senderName=="pbHorizontal"){
      split = showRCeditorDlg(i18n("Enter the desired number of rows:"));
      if(split>=2) vfe->split(currNodeLabel,split,HORIZONTAL);
    }
    else
    if(senderName=="pbVertical"){
      split = showRCeditorDlg(i18n("Enter the desired number of columns:"));
      if(split>=2) vfe->split(currNodeLabel,split,VERTICAL);
    }
    emit launchDraw();
  }
  else KMessageBox::information( this, info1, i18n("Warning") );
  m_hasSelected=false;
}

void FrameWizard::draw(){
  vfe->draw();
}

int FrameWizard::showRCeditorDlg(const TQString &s){
  int res = 0;
  fmRCeditor *dlg = new fmRCeditor;
  dlg->setLabelText(s);
  if(dlg->exec()) res = dlg->spinBoxValue();
  delete dlg;
  return res;
}

void FrameWizard::showFrameEditorDlg(){
  if(m_saved){
    if(m_hasSelected) {
      fmFPeditor *dlg = new fmFPeditor();
      dlg->setup(vfe->internalTree()->findAreaAttribute(m_currSA)->attributeMap());
      if(dlg->exec()) {
        vfe->internalTree()->findAreaAttribute(m_currSA)->setAllAttributes(dlg->attributeMap());
        vfe->draw();
      }
    delete dlg;
    }
    else KMessageBox::information( this, info1, i18n("Warning") );
    m_hasSelected=false;
  }
  else  KMessageBox::information( this, info2, i18n("Warning") );
}

void FrameWizard::reset(){
  vfe->internalTree()->reset();
  draw();
}

void FrameWizard::remove(){
  if(m_hasSelected) {
    vfe->removeNode(m_currSA);
    draw();
  }
  else KMessageBox::information( this, info1, i18n("Warning") );
  m_hasSelected=false;
}

#include "framewizard.moc"
