/***************************************************************************
                          phpdebugdbgp.cpp
                             -------------------
    begin                : 2004-03-12
    copyright            : (C) 2004 Linus McCabe <linus@mccabe.nu>
 ***************************************************************************/

/****************************************************************************
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 ***************************************************************************/

#ifndef QUANTADEBUGGERGUBED_H
#define QUANTADEBUGGERGUBED_H

#include <kserversocket.h>
#include <kstreamsocket.h>
#include <tqptrlist.h>
#include <kurl.h>
#include <tqdom.h>

#include "debuggerclient.h"
#include "dbgpnetwork.h"

typedef TQValueList<TQString> WatchList;
typedef TQMap<TQString, TQString> StringMap;

class QuantaDebuggerDBGp : public DebuggerClient
{
    Q_OBJECT
  TQ_OBJECT

  public:
    QuantaDebuggerDBGp(TQObject *parent, const char* name, const TQStringList&);
    ~QuantaDebuggerDBGp();

    // Execution states
    enum State
    {
      Starting = 0,
      Stopping,
      Stopped,
      Running,
      Break
    };
    // Error codes
    enum Errors
    {
      Warning = 2,
      Notice = 8,
      User_Error = 256,
      User_Warning = 512,
      User_Notice = 1024
    };

    // Protocol version
    static const char protocolversion[];

    // Manager interaction
    const uint supports(DebuggerClientCapabilities::Capabilities);

    // Execution control
    void request();
    void run();
    void stepInto();
    void stepOver();
    void stepOut();
    void pause();
    void kill();
    void setExecutionState(const TQString &state);
    void setExecutionState(const State &state, bool forcesend = false);

    // Connection
    void startSession();
    void endSession();

    // Return name of debugger
    TQString getName();

    // Initiation
    void checkSupport(const TQDomNode&node);

    // New file opened in quanta
    void fileOpened(const TQString& file);

    // Settings
    void readConfig(TQDomNode node);
    void showConfig(TQDomNode node);

    // Breakpoints
    void addBreakpoint(DebuggerBreakpoint* breakpoint);
    void removeBreakpoint(DebuggerBreakpoint* breakpoint);
    void showCondition(const StringMap &args);

    // Variables
    void addWatch(const TQString &variable);
    void removeWatch(DebuggerVariable *var);
    void variableSetValue(const DebuggerVariable &variable);
    void propertySetResponse( const TQDomNode & setnode);

    // Call stack
    void stackShow(const TQDomNode&node);

  private:
    DBGpNetwork m_network;

    TQString m_serverBasedir;
    TQString m_localBasedir;
    TQString m_serverPort;
    TQString m_serverHost;
    TQString m_startsession;
    TQString m_listenPort;
    TQString m_profilerFilename;
    TQString m_appid;
    TQString m_initialscript;
    
    bool    m_useproxy;
    bool    m_profilerAutoOpen;
    bool    m_profilerMapFilename;
    State   m_executionState, m_defaultExecutionState;
    long    m_errormask;
    long    m_displaydelay;
    bool    m_supportsasync;
    
    // Variable type mapping
    StringMap m_variabletypes;

    // Internal watchlist
    WatchList m_watchlist;

    void sendWatches();
    void debuggingState(bool enable);
    void connected();

    void handleError(const TQDomNode & statusnode );
        
    TQString mapServerPathToLocal(const TQString& serverpath);
    TQString mapLocalPathToServer(const TQString& localpath);
    TQString bpToDBGp(DebuggerBreakpoint* breakpoint);
    void setBreakpointKey(const TQDomNode& response);

    TQString attribute(const TQDomNode&node, const TQString &attribute);
    void initiateSession(const TQDomNode& initpacket);

    void typemapSetup(const TQDomNode& typemapnode);
    void showWatch(const TQDomNode& typemapnode);
    DebuggerVariable* buildVariable(const TQDomNode& typemapnode);

    // Profiler
    void profilerOpen(bool forceopen);
    void profilerOpen();
    
  public slots:
    void slotNetworkActive(bool active);
    void slotNetworkConnected(bool connected);
    void slotNetworkError(const TQString &errormsg, bool log);
    void processCommand(const TQString&);
    
  signals:
    void updatetqStatus(DebuggerUI::DebuggertqStatus);
};

#endif
