/***************************************************************************
                          propertysetter.cpp  -  description
                             -------------------
    begin                : gio lug 24 2003
    copyright            : (C) 2003 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "propertysetter.h"

#include <tqlineedit.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqlabel.h>
#include <tqtooltip.h>
#include <tqregexp.h>
#include <tqvbox.h>

#include <kpushbutton.h>
#include <kdebug.h>
#include <kdialog.h>
#include <kiconloader.h>
#include <klocale.h>
#include <klineedit.h>


#include "csseditor_globals.h"
#include "minieditor.h"

propertySetter::propertySetter(TQWidget *parent, const char *name ) : TQHBox(parent,name) {
  m_ind = 0;
  m_cb = 0L;
  m_list.setAutoDelete(true);
  m_pb = 0L;
  setSpacing( KDialog::spacingHint() );
}

propertySetter::~propertySetter(){
  reset();
}

void propertySetter::reset(){
  if(!m_list.isEmpty()) m_list.clear();
  if(m_pb) {
    delete m_pb;
    m_pb=0L;
  }
  m_ind=0;
}

void propertySetter::setComboBox()
{
  m_cb = new TQComboBox(this);
  connect(m_cb, TQT_SIGNAL(activated(const TQString&)), this, TQT_SIGNAL(valueChanged(const TQString&)));
  connect(m_cb, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SIGNAL(valueChanged(const TQString&)));
  m_list.append(m_cb);
}

void propertySetter::setSpinBox(const TQString& initialValue, const TQString& min, const TQString& max, const TQString& s)
{
  mySpinBox *editor = new mySpinBox(min.toInt(), max.toInt(), 1, this);
  editor->setSuffix(s);
  editor->setValue(initialValue.toInt());
  connect(editor, TQT_SIGNAL(valueChanged(const TQString&)), this ,TQT_SIGNAL(valueChanged(const TQString&)));
  m_list.append(editor);
}

void propertySetter::setLineEdit()
{
  TQLineEdit *editor = new TQLineEdit(this);
  connect(editor,TQT_SIGNAL(textChanged ( const TQString & )), this, TQT_SIGNAL(valueChanged ( const TQString & )));
  m_list.append(editor);
}

void propertySetter::setPredefinedColorListEditor()
{  
  TQComboBox *editor = new TQComboBox(this);
  editor->insertStringList(CSSEditorGlobals::HTMLColors);
  connect(editor, TQT_SIGNAL(activated(const TQString&)), this, TQT_SIGNAL(valueChanged(const TQString&)));
  m_list.append(editor);
}

void propertySetter::Show(){
  TQWidget *w;
  for ( w = m_list.first(); w; w = m_list.next() )  
    w->hide();
    
  m_list.at(m_ind)->show();
  
  if(m_list.count() == 1) {
    if(m_pb) 
      m_pb->hide();
  }
  else  
    if(m_ind<(m_list.count()-1)) { 
      m_ind++;
      m_pb->show();
    }
    else 
      m_ind=0;
}

void propertySetter::addButton(){

  m_pb = new KPushButton(this);
  TQToolTip::add(m_pb, i18n( "More..." ));
  TQIconSet iconSet = SmallIconSet(TQString::tqfromLatin1("2rightarrow"));
  TQPixmap pixMap = iconSet.pixmap( TQIconSet::Small, TQIconSet::Normal );
  m_pb->setIconSet(iconSet);
  m_pb->setFixedSize( pixMap.width()+8, pixMap.height()+8 );
  m_pb->hide();
  connect(m_pb, TQT_SIGNAL(clicked()), this ,TQT_SLOT(Show()));
}
    
void propertySetter::installMiniEditor(miniEditor *m){
  m->connectToPropertySetter(this);
  m_list.append(m);
}

#include "propertysetter.moc"
