/***************************************************************************
                          xsldbgdebuggerbase.h  -  The base class from
                                                      which a debugger 
                                                      could be built

                             -------------------
    begin                : Fri Feb 1 2001
    copyright            : (C) 2001 by Keith Isdale
    email                : k_isdale@tpg.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef XSLDBGDEBUGGERBASE_H
#define XSLDBGDEBUGGERBASE_H

#if defined WIN32
#  include <libxsldbg/xsldbgwin32config.h>
#else
#  ifndef  XSLDBG_SO_API
#     define XSLDBG_SO_API
#  endif
#endif

#include <tqobject.h>
#include <tqstringlist.h>
#include <libxml/tree.h>

class XsldbgEvent;
class TQApplication;
class TQStringList;

/** 
    We delegate the task of emitting our signals to XsldbgEvent , so 
    Xsldbg must become our friend
*/
class XsldbgDebuggerBase : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

    friend class XsldbgEvent;

 public:
  XsldbgDebuggerBase(void);
  ~XsldbgDebuggerBase(void);

  void setInitialized(bool state) {initialized = state; };
  bool getInitialized(void) {return initialized ;};

  void setUpdateTimerID(int ID) { updateTimerID = ID;};
  int getUpdateTimerID(void) {return updateTimerID ;};


  /** Convert from libxslt UTF8 to a TQString */	
  static TQString fromUTF8(const char *text);
  static TQString fromUTF8FileName(const char *text);
	
  /** Convert from libxslt UTF8 to a TQString */	
  static TQString fromUTF8(const xmlChar *text);
  static TQString fromUTF8FileName(const xmlChar *text);

  /* list of command yet to be processed */
  TQStringList commandQueue(void) {return _commandQueue ;};
  
  void queueMessage(const TQString &text);

protected:
    TQString updateText;

 private:
  bool initialized;
  int updateTimerID;
  TQStringList _commandQueue;	

  signals: // Signals
   /** line number and/or file name changed */
   void lineNoChanged(TQString /* fileName */, int /* lineNumber */, bool /* breakpoint */);

   /** Show a message in debugger window */
   void showMessage(TQString /* msg*/);

   /** Add breakpoint to view, First parameter is TQString()
       to indicate start of breakpoint list notfication */
   void breakpointItem(TQString /* fileName*/, int /* lineNumber */, 
		       TQString /*templateName*/, TQString /* modeName */,
 		      bool /* enabled */, int /* id */);

  /** Add global variable to view, First parameter is TQString()
      to indicate start of global variable list notfication */
  void globalVariableItem(TQString /* name */, TQString /* fileName */, int /* lineNumber */);

  /** Add local variable to view, First parameter is TQString()
      to indicate start of local variable list notfication */
  void localVariableItem(TQString /*name */, TQString /* templateContext*/,
			 TQString /* fileName */, int /*lineNumber */);	
  
    /** Add a variable to view, First parameter is TQString()
      to indicate start of local variable list notfication */
  void variableItem(TQString /*name */, TQString /* templateContext*/,
			 TQString /* fileName */, int /*lineNumber */, 
			 TQString /* select XPath */, int /* is it a local variable */);	

  /** Add template to view, First parameter is TQString()
      to indicate start of template list notfication */
  void templateItem(TQString /* name*/, TQString /*mode*/, TQString /* fileName */, int /* lineNumber */);

  /** Add source to view, First parameter is TQString()
      to indicate start of source list notfication */
  void sourceItem(TQString /* fileName */, TQString /* parentFileName */, int /*lineNumber */);

  /** Add parameter to view, First parameter is TQString()
      to indicate start of parameter list notfication */
  void parameterItem(TQString /* name*/, TQString /* value */);

  /** Add callStack to view, First parameter is TQString()
      to indicate start of callstack list notfication */
  void callStackItem(TQString /* tempalteName*/, TQString /* fileName */, int /* lineNumber */);
	
  /** Add entity to view, First parameter is TQString()
      to indicate start of entity list notfication */
  void entityItem(TQString /*SystemID*/,  TQString /*PublicID*/);	
	
  /* Show the URI for SystemID or PublicID requested */
  void resolveItem(TQString /*URI*/);
  
  /* Display a integer option value First parameter is TQString()
     to indicate start of option list notification */
  void intOptionItem(TQString /* name*/, int /* value */);

  /* Display a string option value. First parameter is TQString()
     to indicate start of option list notification */
  void stringOptionItem(TQString /* name*/, TQString /* value */);

  /* Cause the names for source, data and output files to be reload from xsldbg */
  void fileDetailsChanged();

};

#endif
