/***************************************************************************
                         listbox.cpp - Listbox widget 
                          -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* KDE INCLUDES */
#include <kglobal.h>
#include <kiconloader.h>

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <specials.h>
#include "listbox.h"

ListBox::ListBox(TQWidget *a_parent, const char *a_name)
  : KListBox(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
}

ListBox::~ListBox()
{
}

TQString ListBox::currentState() const
{
  return TQString("default");
}

bool ListBox::isKommanderWidget() const
{
  return true;
}

TQStringList ListBox::associatedText() const
{
  return KommanderWidget::associatedText();
}

void ListBox::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void ListBox::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString ListBox::populationText() const
{
  return KommanderWidget::populationText();
}

void ListBox::populate()
{
  TQString txt = KommanderWidget::evalAssociatedText(populationText());
  setWidgetText(txt);
}

void ListBox::setWidgetText(const TQString& a_text)
{
  clear();
  insertStringList(TQStringList::split("\n", a_text));
  emit widgetTextChanged(a_text);
}

void ListBox::showEvent(TQShowEvent *e)
{
  TQListBox::showEvent(e);
  emit widgetOpened();
}

bool ListBox::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::selection || f == DCOP::setSelection ||
    f == DCOP::insertItems || f == DCOP::insertItem || f == DCOP::removeItem || f == DCOP::clear ||
    f == DCOP::currentItem || f == DCOP::setCurrentItem || f == DCOP::item || f == DCOP::addUniqueItem ||
      f == DCOP::findItem || f == DCOP::setPixmap || f == DCOP::count || f == DCOP::tqgeometry || f == DCOP::hasFocus || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor;
}

void ListBox::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}


TQString ListBox::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::selection:
    {
      if (selectionMode() == Single)
        return currentText();
      TQString value;
      for (uint i=0; i<count(); i++)
        if (isSelected(i)) 
          value += (value.length() ? "\n" : "") + item(i)->text();
      return value;
    }
    case DCOP::setSelection:
    {
      TQListBoxItem* found = findItem(args[0], TQt::ExactMatch);
      if (found)
        setCurrentItem(index(found));
      break;
    }
    case DCOP::insertItems:
      insertStringList(TQStringList::split("\n", args[0]), args[1].toInt());
      break;
    case DCOP::insertItem:
      insertItem(args[0], args[1].toInt());
      break;
    case DCOP::removeItem:
      removeItem(args[0].toInt());
      break;
    case DCOP::clear:
      clear();
      break;
    case DCOP::count:
      return TQString::number(count());
    case DCOP::currentItem:
      return TQString::number(currentItem());
    case DCOP::setCurrentItem:
    {
      int index = args[0].toInt();
      if (index < (int)count())
        setCurrentItem(index);
      break;
    }
    case DCOP::item:
    {
      int index = args[0].toInt();
      if (index >= 0 && index < (int)count())
        return item(index)->text();
      else
        return TQString();
    }
    case DCOP::addUniqueItem:
      if (!findItem(args[0], TQt::ExactMatch))
        insertItem(args[0]);
      break;
    case DCOP::findItem:
    {
      TQListBoxItem* found = findItem(args[0], TQt::ExactMatch);
      if (!found) found = findItem(args[0], TQt::BeginsWith);
      if (!found) found = findItem(args[0], TQt::Contains);
      if (found)
        return TQString::number(index(found));
      else return TQString::number(-1);
      break;
    }
    case DCOP::setPixmap:
    {
      TQPixmap pixmap = KGlobal::iconLoader()->loadIcon(args[0], KIcon::Small);
      if (pixmap.isNull())
        pixmap.load(args[0]);
      int index = args[1].toInt();
      if (index == -1)
      {
        for (uint i=0; i<count(); i++)
          changeItem(pixmap, text(i), i);
      }
      else if (index < (int)count())
        changeItem(pixmap, text(index), index);
      break;
    }
    case DCOP::text:
    {
      TQStringList strings;
      for(uint i=0; i < count() ; ++i)
        strings += item(i)->text();
      return strings.join("\n");
    }
    case DCOP::tqgeometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::hasFocus:
      return TQString::number(this->hasFocus());
      break;
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "listbox.moc"
