/***************************************************************************
                         groupbox.cpp - Groupbox widget 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>
#include <tqgroupbox.h>
#include <tqobjectlist.h>
#include <klocale.h>

/* OTHER INCLUDES */
#include "kommanderplugin.h"
#include <specials.h>
#include "groupbox.h"


GroupBox::GroupBox(TQWidget *a_parent, const char *a_name)
  : TQGroupBox(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
}

GroupBox::~GroupBox()
{
}

TQString GroupBox::currentState() const
{
	return TQString("default");
}

bool GroupBox::isKommanderWidget() const
{
	return true;
}

TQStringList GroupBox::associatedText() const
{
	return KommanderWidget::associatedText();
}

void GroupBox::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void GroupBox::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString GroupBox::populationText() const
{
    return KommanderWidget::populationText();
}

void GroupBox::populate()
{
    TQString txt = KommanderWidget::evalAssociatedText( populationText() );
//FIXME:    setWidgetText( txt );
}

/* We need to keep track of all widgets created as a child of a groupbox, in order of creation. */
void GroupBox::insertChild(TQObject *a_child)
{
  m_childList.append(a_child);
  TQT_TQOBJECT(this)->TQObject::insertChild(a_child);
}
 
void GroupBox::removeChild(TQObject *a_child)
{
  m_childList.remove(a_child);
  TQT_TQOBJECT(this)->TQObject::removeChild(a_child);
}

void GroupBox::showEvent( TQShowEvent *e )
{
  TQGroupBox::showEvent(e);
  emit widgetOpened();
}

void GroupBox::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

bool GroupBox::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::tqgeometry || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor;
// || (f >= FirstFunction && f <= LastFunction);
}

TQString GroupBox::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
    {
      TQString text;
      for (TQObjectListIt it(m_childList); it.current(); ++it)
        if (dynamic_cast<KommanderWidget*>(it.current()))
          text += (dynamic_cast<KommanderWidget*>(it.current()))->evalAssociatedText();
      return text;
    }
    case DCOP::setText:
      setTitle(args[0]);
      break;
    case DCOP::tqgeometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
  
}

#include "groupbox.moc"
