/***************************************************************************
                         combobox.cpp - Combobox widget 
                             -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqdatetime.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "datepicker.h"

DatePicker::DatePicker(TQWidget *a_parent, const char *a_name)
  : KDatePicker(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
}

DatePicker::~DatePicker()
{
}

TQString DatePicker::currentState() const
{
  return TQString("default");
}

bool DatePicker::isKommanderWidget() const
{
  return true;
}

TQStringList DatePicker::associatedText() const
{
  return KommanderWidget::associatedText();
}

void DatePicker::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void DatePicker::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString DatePicker::populationText() const
{
  return KommanderWidget::populationText();
}

void DatePicker::populate()
{
  setWidgetText(KommanderWidget::evalAssociatedText( populationText()));
}

void DatePicker::setWidgetText(const TQString& a_text)
{
  setDate(TQDate::fromString(a_text, Qt::ISODate));
  emit widgetTextChanged(a_text);
}

TQString DatePicker::widgetText() const
{
    return date().toString(Qt::ISODate); 
}


void DatePicker::showEvent(TQShowEvent *e)
{
    KDatePicker::showEvent( e );
    emit widgetOpened();
}
void DatePicker::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}


bool DatePicker::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::tqgeometry || f == DCOP::hasFocus ;
}

TQString DatePicker::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return date().toString(Qt::ISODate);
    case DCOP::setText:
      setDate(TQDate::fromString(args[0], Qt::ISODate));
      break;    
    case DCOP::tqgeometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::hasFocus:
      return TQString::number(this->hasFocus());
      break;
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "datepicker.moc"
