/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef WORKSPACE_H
#define WORKSPACE_H

#include <tqlistview.h>

class FormWindow;
class TQResizeEvent;
class TQCloseEvent;
class TQDropEvent;
class TQDragMoveEvent;
class TQDragEnterEvent;
class MainWindow;
#ifndef KOMMANDER
class Project;
class SourceFile;
#endif
class FormFile;
class QCompletionEdit;
#ifndef KOMMANDER
    class SourceEditor;
#endif

class WorkspaceItem : public TQListViewItem
{
public:
    enum Type { ProjectType, FormFileType, FormSourceType, SourceFileType };

#ifndef KOMMANDER
    //WorkspaceItem( TQListView *parent, Project* p );
#else
    WorkspaceItem(TQListView *parent);
#endif
#ifndef KOMMANDER
//    WorkspaceItem( TQListViewItem *parent, SourceFile* sf );
#endif
    WorkspaceItem( TQListViewItem *parent, FormFile* ff, Type t = FormFileType );
    WorkspaceItem( TQListView *parent, FormFile* ff, Type t = FormFileType );

    void paintCell( TQPainter *p, const TQColorGroup &cg, int column, int width, int align );

    Type type() const { return t; }

    bool isModified() const;

    TQString text( int ) const;

    void fillCompletionList( TQStringList& completion );
    bool checkCompletion( const TQString& completion );

    TQString key( int, bool ) const; // column sorting key

#ifndef KOMMANDER
    Project* project;
#endif
#ifndef KOMMANDER
    SourceFile* sourceFile;
#endif
    FormFile* formFile;

    void setOpen( bool );

    void setAutoOpen( bool );
    bool isAutoOpen() const { return isOpen() && autoOpen; }

    bool useOddColor;

private:
    void init();
    bool autoOpen;
    TQColor backgroundColor();
    Type t;
};

class Workspace : public TQListView
{
    Q_OBJECT
  TQ_OBJECT

public:
    Workspace( TQWidget *parent , MainWindow *mw );

#ifndef KOMMANDER
    void setCurrentProject( Project *pro );
#endif
#ifdef KOMMANDER
	void makeConnections(MainWindow *);
#endif
    void contentsDropEvent( TQDropEvent *e );
    void contentsDragEnterEvent( TQDragEnterEvent *e );
    void contentsDragMoveEvent( TQDragMoveEvent *e );

    void setBufferEdit( QCompletionEdit *edit );

public slots:

    void update();
    void update( FormFile* );

    void activeFormChanged( FormWindow *fw );
#ifndef KOMMANDER
//    void activeEditorChanged( SourceEditor *se );
#endif

protected:
    void closeEvent( TQCloseEvent *e );
    bool eventFilter( TQObject *, TQEvent * );


private slots:
    void itemClicked( int, TQListViewItem *i, const TQPoint& pos  );
    void itemDoubleClicked( TQListViewItem *i );
    void rmbClicked( TQListViewItem *i, const TQPoint& pos  );
    void bufferChosen( const TQString &buffer );

#ifndef KOMMANDER
//    void projectDestroyed( TQObject* );
#endif

#ifndef KOMMANDER
//    void sourceFileAdded( SourceFile* );
 //   void sourceFileRemoved( SourceFile* );
#endif

    void formFileAdded( FormFile* );
    void formFileRemoved( FormFile* );

private:
    WorkspaceItem *findItem( FormFile *ff );
#ifndef KOMMANDER
    WorkspaceItem *findItem( SourceFile *sf );
#endif

    void closeAutoOpenItems();

private:
    MainWindow *mainWindow;
#ifndef KOMMANDER
    Project *project;
#endif
#ifndef KOMMANDER
    WorkspaceItem *projectItem;
#endif
    QCompletionEdit *bufferEdit;
    bool blockNewForms;
    void updateBufferEdit();
    bool completionDirty;
    void updateColors();

};

#endif
