/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include <tqvbox.h>
#include <tqpainter.h>

#include "previewframe.h"

PreviewFrame::PreviewFrame( TQWidget *parent, const char *name )
    : TQVBox( parent, name )
{
    setMinimumSize(200, 200);
    setFrameStyle(TQFrame::StyledPanel | TQFrame::Sunken);
    setLineWidth(1);

    PreviewWorkspace * w = new PreviewWorkspace( this );
    w->setEraseColor(tqcolorGroup().dark());
    previewWidget = new PreviewWidget( w );
    previewWidget->move( 10, 10 );
}

void PreviewFrame::setPreviewPalette(TQPalette pal)
{
    previewWidget->setPalette(pal);
}

void PreviewWorkspace::paintEvent( TQPaintEvent* )
{
    TQPainter p ( this );
    p.setPen( TQPen( white ) );
    p.drawText ( 0, height() / 2,  width(), height(), AlignHCenter,
		"The moose in the noose\nate the goose who was loose." );
}

#include "previewframe.moc"
